#---------------------------------------------------------------------------
#
#	File:	the-toolkit.tcl
#	Title:	Load File for all Widget Modules
#	Author:	Juergen Wagner (J_Wagner@iao.fhg.de)
#	Date:	Aug 1992
#
#---------------------------------------------------------------------------
#
#	Provide appropriate defaults
#
#---------------------------------------------------------------------------

global system

default style	color		gray

defmethod TheObjects version {} {

  set f [open [the(module) Library version] "r"]
  set version [read -nonewline $f]
  close $f
  return $version
}

default system  theObjects	[TheObjects version]
default system	version		1.1
default system	geometry	+10+10
default system	logos		{FhG-IAO}
default system	applogos	[list $system(system)]

#---------------------------------------------------------------------------
#
#	Periodically flush stdout and stderr
#
#---------------------------------------------------------------------------

proc _flush(stdout) {} {
  flush stdout
  flush stderr
  after 2000 _flush(stdout)
}

_flush(stdout)

#---------------------------------------------------------------------------
#
#	Load all necessary widget definition files
#	-- this should be handled by an auto-loader --
#
#---------------------------------------------------------------------------

if { ! $system(autoload) } {

  # Basic window object
  load(lib) the-window
  # Definitions of the fonts used by widgets
  load(lib) the-fonts
  # Definitions of the colors used by widgets
  load(lib) the-colors

  # Application widget with logos, interaction window, button panel
  load(lib) the-application
  # System environment manipulation
  load(lib) the-env
  # Busy cursor
  load(lib) the-cursor

  # Simple message text
  load(lib) the-message
  # Editable message text
  load(lib) the-text
  # Frames (containers) for other widgets
  load(lib) the-frame
  # Labels of all kinds (text, bitmap, info, ...)
  load(lib) the-label
  # Input lines
  load(lib) the-entry
  # Scale wrapper
  load(lib) the-scale
  # Buttons
  load(lib) the-button
  # Buttons with menus and with menus plus variable labels
  load(lib) the-menubutton
  # Toplevel windows
  load(lib) the-toplevel
  # Horizontal/vertical scroll bars
  load(lib) the-scrollbar
  # Canvas wrapper and scrollable canvases
  load(lib) the-canvas
  # Popup menus
  load(lib) the-popup
  # Single listboxes
  load(lib) the-listbox

  # Live/discrete video input/output widget
  load(lib) the-video
  # Audio input/output routines
  load(lib) the-audio
  # Location broker
  load(lib) the-registrar

  # A simple implementation of panes
  load(lib) the-panes
  # Rectangular array of text items
  load(lib) the-matrix
  # Horizontal menu bars
  load(lib) the-menubar
  # Vertical button collections
  load(lib) the-buttonpanel
  # Multiple listboxes
  load(lib) the-listboxes
  # Various logos
  load(lib) the-logos
  # An input line with a label and some editing
  load(lib) the-inputline
  # An input line with a label and some editing in a toplevel window
  load(lib) the-inputbox
  # Dialog boxes
  load(lib) the-dialog
  # Yes/no dialog boxes
  load(lib) the-yesno
  # Bar charts
  load(lib) the-bars
  # Repeated monitoring of UNIX command output
  load(lib) the-output
  # A text editor
  load(lib) the-textedit
  # Help windows
  load(lib) the-help
  # Text editor for help windows
  load(lib) the-helpedit
  # Selection boxes with various operations
  load(lib) the-simpleselector
  # Selection boxes with various operations
  load(lib) the-selector
  # Double selection box allowing stuff to be clicked from one box to another
  load(lib) the-clickover
  # File selector widget
  load(lib) the-filesel
  # Various filter functions
  load(lib) the-filter
  # Attribute-value list widget (form)
  load(lib) the-alist
  # Indented list (simple tree representation) widgets
  load(lib) the-ilist
  # Gantt-type diagrams for resources and activities
  load(lib) the-timeline
  # Tree (DAG) display widget
  load(lib) the-dag
  # Function graph widget
  load(lib) the-graph
  # A widget to display a computer network
  load(lib) the-network
  # A canvas widget drawing countries and cities
  load(lib) the-country
  # A Petri net animation widget
  load(lib) the-petri

  # Simple debugger for Tcl/Tk
  load(lib) the-debugger
}
