## font.tcl Procedures for changing fonts
## ==============
## Copyright (C) 1992-1993
## Global Network Academy
## Macvicar Institute for Educational Software Development
##
## See the file COPYRIGHT for conditions

## The procedures in this file are responsible for font display

## Conventions:
##   All procedures in this file begin with tkW3Font

set tkW3FontTimesFonts { \
    {"" "-adobe-times-medium-r-*-*-12-*-*-*-*-*-*-*"}
    {"H1" "-adobe-times-bold-r-normal-*-24-*-*-*-*-*-*-*"} 
    {"H2" "-adobe-times-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H3" "-adobe-times-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H4" "-adobe-times-bold-r-normal-*-14-*-*-*-*-*-*-*"} 
    {"H5" "-adobe-times-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"H6" "-adobe-times-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"ADDRESS" "-adobe-times-medium-i-normal-*-14-*-*-*-*-*-*-*"} 
    {"XMP" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"PRE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}

    {"TT"  "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"CODE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"SAMP" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"B" "-adobe-times-bold-r-*-*-12-*-*-*-*-*-*-*"}
    {"EM" "-adobe-times-bold-r-*-*-12-*-*-*-*-*-*-*"}
    {"I" "-adobe-times-medium-i-*-*-12-*-*-*-*-*-*-*"}
    
}

set tkW3FontHelveticaFonts { \
    {"" "-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*"}
    {"H1" "-adobe-helvetica-bold-r-normal-*-24-*-*-*-*-*-*-*"} 
    {"H2" "-adobe-helvetica-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H3" "-adobe-helvetica-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H4" "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*"} 
    {"H5" "-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"H6" "-adobe-helvetica-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"ADDRESS" "-adobe-helvetica-medium-o-normal-*-14-*-*-*-*-*-*-*"} 
    {"XMP" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"PRE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}

    {"TT"  "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"CODE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
}

set tkW3FontNewCenturyFonts { \
    {"" "-adobe-new century schoolbook-medium-r-*-*-12-*-*-*-*-*-*-*"}
    {"H1" "-adobe-new century schoolbook-bold-r-normal-*-24-*-*-*-*-*-*-*"} 
    {"H2" "-adobe-new century schoolbook-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H3" "-adobe-new century schoolbook-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H4" "-adobe-new century schoolbook-bold-r-normal-*-14-*-*-*-*-*-*-*"} 
    {"H5" "-adobe-new century schoolbook-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"H6" "-adobe-new century schoolbook-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"ADDRESS" "-adobe-new century schoolbook-medium-i-normal-*-14-*-*-*-*-*-*-*"} 
    {"XMP" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"PRE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}

    {"TT"  "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"CODE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
}

set tkW3FontLucidaFonts { \
    {"" "-b&h-lucida-medium-r-*-*-12-*-*-*-*-*-*-*"}
    {"H1" "-b&h-lucida-bold-r-normal-*-24-*-*-*-*-*-*-*"} 
    {"H2" "-b&h-lucida-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H3" "-b&h-lucida-bold-r-normal-*-18-*-*-*-*-*-*-*"} 
    {"H4" "-b&h-lucida-bold-r-normal-*-14-*-*-*-*-*-*-*"} 
    {"H5" "-b&h-lucida-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"H6" "-b&h-lucida-bold-r-normal-*-12-*-*-*-*-*-*-*"} 
    {"ADDRESS" "-b&h-lucida-medium-i-normal-*-14-*-*-*-*-*-*-*"} 
    {"XMP" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"PRE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}

    {"TT"  "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
    {"CODE" "-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*"}
}

proc tkW3FontSetTextFonts {w list} {
    foreach font $list {
	set style [lindex $font 0]
	if {$style == ""} {
	    $w configure -font [lindex $font 1]
	} else {
	    $w tag configure $style -font [lindex $font 1]
	}
    }
    $w tag configure U -underline true
}

proc tkW3FontInitialize {} {
    global tkW3FontTimesFonts
    global tkW3FontHelveticaFonts
    global tkW3FontNewCenturyFonts
    global tkW3FontLucidaFonts

    set list {
	{tkW3FontTimesFonts "Times (Default)"}
	{tkW3FontHelveticaFonts "Helvetica"}
	{tkW3FontNewCenturyFonts "New Century Schoolbook"}
	{tkW3FontLucidaFonts "Lucida Bright"}
    }
    DLG:toplevel . .font_dialog
    pack append .font_dialog \
	[frame .font_dialog.f] top 
    foreach item $list {
	pack append .font_dialog.f \
	    [radiobutton .font_dialog.f.[lindex $item 0] \
	     -text [lindex $item 1] -relief flat \
		 -variable font_name \
                 -anchor w ] {top fillx}
    }
    DLG:draw_buttons .font_dialog  {"OK" "Apply" "Cancel"}

    DLG:bind_button .font_dialog 1 \
	"tkW3FontSetTextFonts .f.msg \[set \$font_name\]
DLG:hide .font_dialog"
    DLG:bind_button .font_dialog 2 \
	"tkW3FontSetTextFonts .f.msg \[set \$font_name\]"
    DLG:bind_button .font_dialog 3 "DLG:hide .font_dialog"

    tkW3FontSetTextFonts .f.msg $tkW3FontTimesFonts
}
	
	
    
