## hypertext.tcl Procedures for processing the hypertext
## ==============
## Copyright (C) 1992-1993
## Global Network Academy
## Macvicar Institute for Educational Software Development
##
## See the file COPYRIGHT for conditions

## Conventions:
## The procedures in this procedure have names which begin with tkW3Ht

set tkW3HtMaxAnchor 0
set tkW3HtMaxImage 0
set tkW3HtNameToHnumber() bar

proc tkW3HtInsert {text {list ""}} {
    set start [.f.msg index insert]
    .f.msg insert insert $text
    foreach tag [.f.msg tag names $start] {
        .f.msg tag remove $tag $start insert
    }
    foreach tag $list {
	.f.msg tag add $tag $start insert
    }
}

proc tkW3HtSetName {address title} {
    tkW3OutputSetAddress $address $title
}
 
proc tkW3HtBeginDoc {} {
    global tkW3HtAnchors  tkW3HtImages
    global tkW3HtListLevel tkW3HtStyleStack tkW3NavigateIsIndex
    global tkW3HtNameToHnumber tkW3HtCharStyle tkW3EditModified
 
    set tkW3HtAnchors(index) 1
    set tkW3HtImages(index) 1
    set tkW3HtAnchors(in_anchor) 0
    set tkW3HtListLevel 0
    set tkW3HtStyleStack {}
    set tkW3HtImages(index) 1
    set tkW3HtCharStyle {}
    set tkW3NavigateIsIndex 0
    unset tkW3HtNameToHnumber
    set tkW3HtNameToHnumber() bar
    .f.msg delete 1.0 end
    set tkW3EditModified 0
}

proc tkW3HtBeginAnc {name href} {
    global tkW3HtAnchors tkW3HtNameToHnumber tkW3HtMaxAnchor

    set i $tkW3HtAnchors(index)
    set tkW3HtAnchors(name.$i) $name
    set tkW3HtAnchors(href.$i) $href
    set tkW3HtNameToHnumber($name) $i
    set tkW3HtAnchors(in_anchor) 1
    if {$tkW3HtAnchors(index) > $tkW3HtMaxAnchor} {
	.f.msg tag configure h$i -relief raised -borderwidth 2 -background \
	    [lindex [.f.msg configure -background] 4]

	.f.msg tag bind h$i <ButtonPress> \
	    "%W tag configure h$i -relief sunken
update idletasks"
	.f.msg tag bind h$i <ButtonRelease-1> \
	    "%W tag configure h$i -relief raised
tkW3NavigateRecordAndGoto \$tkW3HtAnchors(href.$i)"
	.f.msg tag bind h$i <ButtonRelease-2> \
	    "%W tag configure h$i -relief raised
tkW3NavigateClone \$tkW3HtAnchors(href.$i)"
	.f.msg tag bind h$i <ButtonRelease-3> \
	    "%W tag configure h$i -relief raised
tkW3EditBeginAnchor %W $i"
	incr tkW3HtMaxAnchor
    }
}

proc tkW3HtEndAnc {} {
    global tkW3HtAnchors
    set tkW3HtAnchors(in_anchor) 0
    incr tkW3HtAnchors(index)
}

proc tkW3HtAdd {string} {
    global tkW3HtAnchors tkW3HtStyleStack tkW3HtCharStyle

    set styles ""
    if {$tkW3HtAnchors(in_anchor) == 1} {
	lappend styles Anchor
	lappend styles h$tkW3HtAnchors(index)
    }
    lappend styles \
	[lindex $tkW3HtStyleStack [expr "[llength $tkW3HtStyleStack]-1"]]

    if {$tkW3HtCharStyle != ""} {
	lappend styles $tkW3HtCharStyle
    }
    tkW3HtInsert $string $styles
}

proc tkW3HtBeginPar {elem} {
    global tkW3HtStyleStack tkW3HtListLevel

    lappend tkW3HtStyleStack $elem
    
    if {[regexp {^H[1-9]+$} $elem] ||  $elem == "ADDRESS"} {
	tkW3HtBlankLines 2
    }
   
    if {$elem == "MENU" || $elem == "DL" || $elem == "UL" || $elem == "OL"} {
	incr tkW3HtListLevel
	tkW3HtInsert " " $elem.mark
    }
}

proc tkW3HtEndPar {elem} {
    global tkW3HtStyleStack tkW3HtListLevel

    set index [expr "[llength $tkW3HtStyleStack]-2"]
    set tkW3HtStyleStack [lrange $tkW3HtStyleStack 0 $index]

    if {[regexp {^H[1-9]+$} $elem]  || $elem == "ADDRESS"}  {
	tkW3HtBlankLines 1
    }
    if {$elem == "MENU" || $elem == "DL" || $elem == "UL" || $elem == "OL"} {
	tkW3HtInsert "\n" "/$elem.mark"
    }

    if {$elem == "MENU" || $elem == "DL" || $elem == "UL" || $elem == "OL"} {
	incr tkW3HtListLevel -1
	tkW3HtInsert "\n" "/$elem.mark"
    }
}

proc tkW3HtBeginChar {elem} {
    global tkW3HtCharStyle
    set tkW3HtCharStyle $elem
}

proc tkW3HtEndChar {elem} {
    global tkW3HtCharStyle
    set tkW3HtCharStyle ""
}

proc tkW3HtEndDoc {} {
    global tkW3HtImages
    set address [tkW3NavigateGetAddress]
    for {set i 1} {$i < $tkW3HtImages(index)} {incr i} {
	if {$tkW3HtImages($i.anchor) != ""} {
	    set tkW3HtImages($i.anchor) \
		[tkW3NavigateServerSend \
		 [list HtParseName $tkW3HtImages($i.anchor) $address]]
	}
    }
}

proc tkW3HtAddBul {type} {
    global tkW3HtListLevel

    if {$type == "P"} {
	tkW3HtInsert "\n\n" P
	return
    }

    if {$type == "DT"} {
	tkW3HtBlankLines 1
    }

    tkW3HtInsert "\n" blank
    for {set i 1} {$i < $tkW3HtListLevel} {incr i} {
	tkW3HtInsert "     " blank
    }

    case $type {
	"LI" {
	    tkW3HtInsert "* " LI
	}
	"DD" {
	    tkW3HtInsert "   * " DD
	}
	"DT" {
	    tkW3HtInsert "* " DT
	}
    }
}

proc tkW3HtSetImg {source ismap} {
    global tkW3HtImages tkW3HtAnchors
    global tkW3HtMaxImage

    set image_string "<IMAGE"
    set i $tkW3HtImages(index)

    set tkW3HtImages($i.ismap) $ismap   
    if {$tkW3HtAnchors(in_anchor)} {
	set tkW3HtImages($i.anchor) $tkW3HtAnchors(href.$tkW3HtAnchors(index))
        append image_string "-ANCHOR"
	if {$ismap} {
	    append image_string "-ISMAP"
	}
    } {
	set tkW3HtImages($i.anchor) ""
    }
  
    append image_string ">"

    tkW3HtInsert $image_string "Image i$i"
    if {$tkW3HtImages(index) > $tkW3HtMaxImage} {
	.f.msg tag configure i$i -relief raised -borderwidth 2 -background \
	    [lindex [.f.msg configure -background] 4]
	.f.msg tag bind i$i <ButtonPress> \
	    "%W tag configure i$i -relief sunken
update idletasks"
	.f.msg tag bind i$i <ButtonRelease-1> \
	    "%W tag configure i$i -relief raised
tkW3NavigateRecordAndGoto \$tkW3HtImages($i) {} \$tkW3HtImages($i.anchor) \$tkW3HtImages($i.ismap)"
	.f.msg tag bind i$i <ButtonRelease-2> \
	    "%W tag configure i$i -relief raised
tkW3NavigateClone \$tkW3HtImages($i) \
	\$tkW3HtImages($i.anchor) \$tkW3HtImages($i.ismap)"
	.f.msg tag bind i$i <ButtonRelease-3> \
	    "%W tag configure i$i -relief raised
tkW3EditChangeImage $tkW3HtImages(index)"
    }
    set tkW3HtImages($tkW3HtImages(index)) $source
    incr tkW3HtImages(index)
}

proc tkW3HtSetInd {} {
    global tkW3NavigateIsIndex
    set tkW3NavigateIsIndex 1
}

proc tkW3HtBlankLines {n} {
    set text \
	[regexp {^[ ]*$} [.f.msg get {insert linestart} {insert - 1 char lineend}]]
    if {!$text} {
	for {set i 0} {$i<$n} {incr i} {
	    tkW3HtInsert "\n" blank
	}
    }
}
