## menu.tcl: make menu out of list of node names
## ==============
## Copyright (C) 1992-1993
## Global Network Academy
## Macvicar Institue for Educational Software Development
##
## See the file COPYRIGHT for conditions

## Conventions:
## All procedures in this file begin with tkW3Menu

# tkW3MenuMakeMenus 
# Add items to the menu bar to allow direct access of
# some information
# The format for the input list is
# {{menuname1 title1} {{title1 address1} {title2 address2}}} 
#  {menuname2 title2} {{title1 address1}}}}
#
# returns a list of menus created

proc tkW3MenuMakeMenus {menubar list} {
    frame $menubar
    
    set menu_list ""
    foreach menu_item $list {
        set menu [lindex $menu_item 0]
        set menu_name $menubar.[lindex $menu 0]
        set menu_title [lindex $menu 1]
        set menu_underline [lindex $menu 2]
        set menu_command [lindex $menu 3]
        
        if {$menu_command == "right"} {
	    set position "right"
	} {
	    set position "left"
	}

	pack append $menubar \
	    [menubutton $menu_name -text $menu_title \
             -menu $menu_name.m] $position
        if {$menu_underline != ""} {
	    $menu_name configure -underline $menu_underline
	}

        if {"$menu_command" == "goto"} {
            tkW3MenuMakeNodeMenu $menu_name.m [lindex $menu_item 1]
	} {
	    tkW3MenuMakeMenuPane $menu_name.m [lindex $menu_item 1]
	}
        lappend menu_list $menu_name
    }
    eval tk_menuBar $menubar $menu_list
    tk_bindForTraversal . 
    return $menubar
}


# tkW3MenuMakeNodeMenu
# make a menu from a list of titles and addresses
# This is called by the bookmarks and the history utilities
# the format for the input list is {{title1 address1} {title2 address2} ...}

proc tkW3MenuMakeNodeMenu {menuname list} {
    # Destroy the menu if it exists
    catch {destroy $menuname}
    # Create a new one
    menu $menuname
    # Run through the list of titles and add menu items
    foreach item $list {
        if {$item == {}} then {
	    $menuname add separator
	} else {
	    set address [lindex $item 1]
	    if {"$address" == "cascade_goto"} {
		$menuname add cascade -label "[lindex $item 0] =>" \
		    -menu [tkW3MenuMakeNodeMenu $menuname.m \
			   [lindex $item 2]]
		
		if {[lindex $item 3] != ""} {
		    $menuname entryconfigure last \
			-underline [lindex $item 3]
		}
	    } else {
		set command [list tkW3NavigateRecordAndGoto [lindex $item 1]]
		set menu_text_position [ lindex $item 3 ]
		if {$menu_text_position != ""} {
		    lappend command $menu_text_position
		}
		$menuname add command -label [lindex $item 0] \
		    -command $command

		if {[lindex $item 2] != ""} {
		    $menuname entryconfigure last \
			-underline [lindex $item 2]
		}
	    }
	}
    }
    return $menuname
}

# tkW3MenuAddToNodeMenu
# Add one entry into the node menu

proc tkW3MenuAddToNodeMenu {menuname label address} {
    if {[catch "winfo class $menuname"]} {
	menu $menuname
    }
    $menuname add command -label $label \
	-command [list tkW3NavigateGoto $address]
} 

proc tkW3MenuMakeMenuPane {w menu_list} {
    global tk_version
    menu $w
    set tk_version_list [split $tk_version "."]
foreach item $menu_list {
if {[llength $item] == 0} {
	   $w add separator
       } { 
	   if {"[lindex $item 1]" == "cascade_external"} {
	       set name [lindex $item 0]
	       if {[lindex $tk_version_list 0] <= 3 &&
		   [lindex $tk_version_list 1] <= 2} {
		       append name " =>"
		   }
	       $w add cascade -label $name -menu $w.[lindex $item 2]
	       menu $w.[lindex $item 2]
	   } {
	       if {"[lindex $item 1]" == "cascade"} {
		   set name [lindex $item 0]
		   if {[lindex $tk_version_list 0] <= 3 &&
		       [lindex $tk_version_list 1] <= 2} {
			   append name " =>"
		       }
		   $w add cascade -label $name \
		       -menu [tkW3MenuMakeMenuPane $w.m [lindex $item 2]]
	       } {
		   $w add command -label [lindex $item 0] \
		       -command [lindex $item 1]
		   if {[lindex $item 2] != ""} {
		       $w entryconfigure last -underline [lindex $item 2]
		   }
		   if {[lindex $item 3] != ""} {
		       $w entryconfigure last -accelerator [lindex $item 3]
		       bind Text [lindex $item 3] [lindex $item 1] 
		   } 
	       }
	   }
       }
}
return $w
}
