#==============================================================================
#                                 Config.mk
#------------------------------------------------------------------------------
# Configuration file for Tcl sipp.  Edit the following variables to specify
# the location of required packages and other attribbutes.   
#
# IMPORTANT NOTE:
#     All paths should either be absoulte or relative to the src & photo
# directories  below the directory containing this file (../../).
#------------------------------------------------------------------------------

#------------------------------------------------------------------------------
# Version number of tsipp (Don't change this).
#
TSIPP_VERSION = 3.1a

#------------------------------------------------------------------------------
# C compiler & ar commands to use. CC is normally specified on the make
# command line (make CC=gcc).
#
#CC  = cc
AR  = ar

#------------------------------------------------------------------------------
# Compiler debug/optimization/profiling flag to use.  Normally specified on
# the make command line (make CFLAGS=-g).

#CFLAGS=

#------------------------------------------------------------------------------
# EXtra flags:
#   o XCFLAGS - Extra compiler flags on all compiles and links
#   o XLDFLAGS - Extra compiler flags to specify at link time.
#   o XLDLIBS - Extra libraries to use at link time.

#XCFLAGS=
#XLDFLAGS=
#XLDLIBS=

#------------------------------------------------------------------------------
# Location of the TclX build tree and the tclmaster and tk master directories
#
TCLXDIR    = ../../tclX7.3b
TCLXMASTER = ${TCLXDIR}/tclmaster
TKXMASTER  = ${TCLXDIR}/tkmaster

#------------------------------------------------------------------------------
# TCLXINCL is the directory containing the Tcl & Extended Tcl (TclX) include
# files (tclExtend.h).
# TCLLIB is the path to the Tcl library (libtcl.a).
# TCLXLIB is the path to the  Extended Tcl library (libtclx.a).
#
TCLXINCL = -I${TCLXMASTER}/include
TCLLIB  = ${TCLXMASTER}/lib/libtcl.a
TCLXLIB  = ${TCLXMASTER}/lib/libtclx.a

#------------------------------------------------------------------------------
# Define the URTDEF, URTINCL and URTLIB if you are building with the Utah
# Raster Toolkit (URT).  Comment these out if you don't have the URT toolkit.
#
# URTINCL is the directory containing the URT RLE file (rle.h).
# URTLIB is the path to the URT RLE library (librle.h).
#
URTDEF  = -DTSIPP_HAVE_RLE
URTINCL = -I/usr/local/include
URTLIB  = /usr/local/lib/librle.a

#------------------------------------------------------------------------------
# These options need to be defined if you want to build tksipp, a version of
# the Tk shell wish with the SIPP command set and the photo widget. Comment
# these out if your don't want to build tksipp.  You must have compiled
# Extended Tcl with the TK_BUILD=WISHX option set in its configuration file.
# (If you have wishx, you did).
#
# TKINCL is the directory of your Tk source include files.  It does not have
# to be built, but this must point to the source distribution.
# TKLIB is the path to Tk library (libtk.a)
# TKXLIB is the path to Extended Tk library (libtkx.a)
# XLIBS are the libraries to use for X11.
#
TKSIPP_BUILD = TKSIPP_BUILD
TKINCL = -I../../tk3.6
TKLIB  = ${TKXMASTER}/lib/libtk.a
TKXLIB = ${TKXMASTER}/lib/libtkx.a

#------------------------------------------------------------------------------
# TSIPP master diectory path.  A directory containing the tsipp version number
# is built under here.
#
MASTERDIR=${prefix}/tsipp

#------------------------------------------------------------------------------
# Public bin and lib directories where symbolic links to the external files
# in the master directory are placed
#
BINDIR=${prefix}/bin
LIBDIR=${prefix}/lib

#------------------------------------------------------------------------------
# o TSIPP_MAN_CMD_SECTION - Section for tsipp command manual pages. Normal `1'
#   or `C'.  You might perfer TSIPP or what you specified with TclX.

TSIPP_MAN_CMD_SECTION=TSIPP
#TSIPP_MAN_CMD_SECTION=1

#------------------------------------------------------------------------------
# o MAN_DIR_SEPARATOR - The separator character used in the directory name
#   of the cat* and man* manual directories.  This is usually empty or 
#   a period. i.e "/usr/man/man1" or "/usr/man/man.1".

MAN_DIR_SEPARATOR=

#------------------------------------------------------------------------------
# Arguments to use in when generating the demo pictures when you do a
# "make demo".  The following arguments may be specified for this flag:
#
#     o -mode rmode - The rendering mode.  The value of rmode is one of PHONG,
#        GOURAUD, FLAT or LINE.  Default is PHONG.
#     o -oversample factor - The oversampling factor.  The default is 2 for
#        most images, a couple are 3.  You might want to set this to 1 to speed
#        up the rendering.
#     o -size isize - The size of the image to render.  The result will be an
#        image isize X isize pixels.  The default is 256 pixels.
#     o -ppm - Force PPM (or PBM for LINE mode) format images to be rendered.
#        The default is to render RLE images if Tcl-SIPP was built with the 
#        Utah Raster Toolkit RLE library and a PPM images if RLE is not
#        available.
#        
DEMOARGS=
