/* 
 * main.c --
 *
 *	A simple program to test the toolkit facilities.
 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header: /user6/ouster/wish/RCS/main.c,v 1.68 92/05/07 08:52:02 ouster Exp $ SPRITE (Berkeley)";
#endif

/* ----------------
 *	include files
 * ----------------
 */
#include "tkConfig.h"
#include "tkInt.h"
    
#define TK_EXTENDED
#include "tclExtend.h"
    
/* ----------------
 * 	declarations
 * ----------------
 */
Tcl_Interp *tk_mainInterp;  /* Need to process signals */

extern int isatty();

char initCmd[] = "load wishx.tcl";

Tk_Window 	w;			/* NULL means window has been deleted. */
Tk_TimerToken 	timeToken = 0;
int 	    	idleHandler = 0;
Tcl_Interp 	*interp;
int	    	x, y;
Tcl_CmdBuf  	buffer;
int 	    	tty;

extern void StdinProc();
extern void StructureProc();
extern void DelayedMap();

extern int  DotCmd();
extern int  MovetoCmd();
extern int  LinetoCmd();
extern int  Tcl_VarframeCmd();

/*
 * Information for testing out command-line options:
 */

int synchronize = 0;
char *fileName = NULL;
char *name = NULL;
char *display = NULL;
char *geometry = NULL;

Tk_ArgvInfo argTable[] = {
    {"-file",     TK_ARGV_STRING, (char *) NULL, (char *) &fileName,	"File from which to read commands"},
    {"-geometry", TK_ARGV_STRING, (char *) NULL, (char *) &geometry,	"Initial geometry for window"},
    {"-display",  TK_ARGV_STRING, (char *) NULL, (char *) &display,	"Display to use"},
    {"-name",     TK_ARGV_STRING, (char *) NULL, (char *) &name,	"Name to use for application"},
    {"-sync",     TK_ARGV_CONSTANT, (char *) 1, (char *)  &synchronize,	"Use synchronous mode for display server"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,	(char *) NULL}
};

/* ----------------
 *	main
 * ----------------
 */

int
main(argc, argv)
    int argc;
    char **argv;
{
    char *args, *p, *msg;
    char buf[20];
    int result;
    Tk_3DBorder border;

    tk_mainInterp = interp = Tcl_CreateExtendedInterp();
    
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(interp);
#endif
    
    if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
	    != TCL_OK) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }
    if (name == NULL) {
	if (fileName != NULL) {
	    p = fileName;
	} else {
	    p = argv[0];
	}
	name = strrchr(p, '/');
	if (name != NULL) {
	    name++;
	} else {
	    name = p;
	}
    }
    w = Tk_CreateMainWindow(interp, display, name);
    if (w == NULL) {
	fprintf(stderr, "%s\n", interp->result);
	exit(1);
    }
    Tk_SetClass(w, "Tk");
    Tk_CreateEventHandler(w, StructureNotifyMask, StructureProc,  (ClientData) NULL);
    Tk_DoWhenIdle(DelayedMap, (ClientData) NULL);
    tty = isatty(0);

    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);

    if (synchronize) {
	XSynchronize(Tk_Display(w), True);
    }
    Tk_GeometryRequest(w, 200, 200);
    border = Tk_Get3DBorder(interp, w, None, "#4eee94");
    if (border == NULL) {
	Tcl_SetResult(interp, (char *) NULL, TCL_STATIC);
	Tk_SetWindowBackground(w, WhitePixelOfScreen(Tk_Screen(w)));
    } else {
	Tk_SetBackgroundFromBorder(w, border);
    }
    XSetForeground(Tk_Display(w), DefaultGCOfScreen(Tk_Screen(w)),
	    BlackPixelOfScreen(Tk_Screen(w)));
    
    /* ----------------
     *	misc wish routines
     *	TCP connection
     *	miro class support
     * ----------------
     */
    Tcl_CreateCommand(interp,  "dot",    DotCmd,     (ClientData) w,    (void (*)()) NULL);
    Tcl_CreateCommand(interp,  "lineto", LinetoCmd,  (ClientData) w,    (void (*)()) NULL);
    Tcl_CreateCommand(interp,  "moveto", MovetoCmd,  (ClientData) w,    (void (*)()) NULL);
    
    Tcl_CreateCommand(interp, "varframe", Tcl_VarframeCmd, (ClientData) w, (void (*)()) NULL);
    
    if (geometry != NULL) {
	Tcl_SetVar(interp, "geometry", geometry, TCL_GLOBAL_ONLY);
    }
    
    tclAppName     = "Wish";
    tclAppLongname = "Wish - Tk Shell";
    tclAppVersion  = TK_VERSION;
    Tcl_ShellEnvInit (interp, TCLSH_ABORT_STARTUP_ERR,
                      name,
                      0, NULL,           /* argv var already set  */
                      fileName == NULL,  /* interactive?          */
                      NULL);             /* Standard default file */
    
    result = Tcl_Eval(interp, initCmd, 0, (char **) NULL);
    if (result != TCL_OK) {
	goto error;
    }
    if (fileName != NULL) {
	result = Tcl_VarEval(interp, "source ", fileName, (char *) NULL);
	if (result != TCL_OK) {
	    goto error;
	}
	tty = 0;
    } else {
	tty = isatty(0);
	Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
	if (tty) {
	    printf("wish: ");
	}
    }
    fflush(stdout);
    buffer = Tcl_CreateCmdBuf();
    (void) Tcl_Eval(interp, "update", 0, (char **) NULL);

    Tk_MainLoop();
    Tcl_DeleteInterp(interp);
    Tcl_DeleteCmdBuf(buffer);
    exit(0);

error:
    msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    if (msg == NULL) {
	msg = interp->result;
    }
    fprintf(stderr, "%s\n", msg);
    Tcl_Eval(interp, "destroy .", 0, (char **) NULL);
    exit(1);
    return 0;
}
