/*  $Id: xbm2ikon.c,v 1.3 1996/12/02 12:20:32 parmente Exp $
 *
 *  Small program to take an X11 xbm format on standard input and convert
 *  it to  blit icon on output.
 *
 * from ikon2xbm.c, by Thierry Parmentelat, IXI, France
 *
 * originally in ikon2xbm.c:
 * 
 * From ikon2icon.c by:
 *  Copyright (c) Rich Burridge - Sun Microsystems Australia.
 * 
 *  Permission is given to distribute these sources, as long as the
 *  copyright messages are not removed, and no monies are exchanged. 
 *
 *  No responsibility is taken for any errors on inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  to me, then an attempt will be made to fix them.
 */

#include <stdio.h>

#define  PATCHLEVEL  1

#define  FGETS       (void) fgets     /* To make lint happy. */
#define  PRINTF      (void) printf
#define  SCANF       (void)  scanf

#ifdef  NOINDEX
#define  index        strchr
#endif /*NOINDEX*/

#define  BLITHEIGHT  48       /* Maximum number of lines in a blit icon. */
#define  MAXLINE     80       /* Maximum length for character strings. */

char *index() ;
unsigned char buf[6][48] ;    /* Buffer for blit icon info. */

/* ------------------------------------------------------------ */
/* This table is the same as in ikon2xbm			*/
/* will be reversed in ``reverse'' by init_reverse		*/
/* ------------------------------------------------------------ */
unsigned char bitswaptbl[256] = {
        0x00, 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0,
        0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0,
        0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8,
        0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8,
        0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4,
        0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4,
        0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec,
        0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc,
        0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2,
        0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2,
        0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea,
        0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa,
        0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6,
        0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6,
        0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee,
        0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe,
        0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1,
        0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1,
        0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9,
        0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9,
        0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5,
        0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5,
        0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed,
        0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd,
        0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3,
        0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3,
        0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb,
        0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb,
        0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7,
        0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7,
        0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef,
        0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff,
};

unsigned char reverse[256];

main()
{
  init_reverse();
  read_icon() ;      /* Read blit info to internal buffer. */
  make_blit() ;
  exit(0);
}


init_reverse () {
  int i;
  for (i=0;i<256;i++) {
    reverse[bitswaptbl[i]]=i;
  }
}

read_icon()        /* Create X11 bitmap on standard output. */
{
  int i, j ;
  int v0,v1;
  
  char line[MAXLINE];
  FGETS(line,MAXLINE,stdin);	/* skip header */
  FGETS(line,MAXLINE,stdin);	/* skip header */
  FGETS(line,MAXLINE,stdin);	/* skip header */
  for (i = 0; i < BLITHEIGHT; i++) {
    for (j = 0; j < 6; j += 2) {
      SCANF(" 0x%02x, 0x%02x,", &v0, &v1);
      buf[j+1][i]=v0;
      buf[j][i]=v1;
    }
  }
}

make_blit()                         /* Read rasterfile into internal buffer. */
{
  char nextline[MAXLINE], *ptr ;    /* Next line from blit icon file. */
  int i, j, v0, v1 ;

  for (i = 0; i < BLITHEIGHT; i++) {
    for (j = 0; j < 3; j++) {
      PRINTF("0x%02X%02X,",reverse[buf[j*2+1][i]],reverse[buf[2*j][i]]) ;
    }
    PRINTF("\n");
  }
}
