# dirlist.tcl --
#
# Create a HTML-formatted directory listing
#
# Steve Ball (c) 1997 Sun Microsystems
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# SCCS: @(#) dirlist.tcl 1.4 97/07/03 15:43:01

package provide dirlist 1.0
 
proc DirList {dir urlpath} {
    global tcl_platform
 
    if [string compare macintosh $tcl_platform(platform)] {
	set what Directory
	set lwhat directory
    } else {
	set what Folder
	set lwhat folder
    }
    set listing "<HTML>
<HEAD>
<TITLE>Listing of $what $urlpath</TITLE>
</HEAD>
<BODY>
<H1>Listing of $what $urlpath</H1>
<UL>
"
    set path [file split $dir]
    # 8.0 dictionary sort seems broken if directory contains a number
    # lsort -dict [glob -nocomplain -- [file join $dir *]]
    set list [lsort -command DirlistCompare \
	[glob -nocomplain -- [file join $dir *]]]

    if {[llength $path] > 1} {
	append listing \
	    "<LI DINGBAT=\"folder\"><A HREF=\"..\">Up to parent $lwhat</A>\n"
    }
 
    if [string compare {} $list] {
	foreach entry $list {
	    file lstat $entry lst
	    switch $lst(type) {
		file {
		    # Should determine dingbat from file type
		    append listing "<LI DINGBAT=\"file\"><A HREF=\"[file tail $entry]\">[file tail $entry]</A>, $lst(size) bytes, last modified [clock format $lst(mtime) -format {%A, %B %d %Y}]\n"
		}
		directory {
		    append listing "<LI DINGBAT=\"folder\"><A HREF=\"[file tail $entry]\">[file tail $entry]</A>, last modified [clock format $lst(mtime) -format {%A, %B %d %Y}]\n"
		}
		link {
		    append listing "<LI DINGBAT=\"link\"><A HREF=\"[file tail $entry]\">[file tail $entry]</A> -> [file readlink $entry]\n"
		}
		characterSpecial -
		blockSpecial -
		fifo -
		socket {
		    append listing "<LI DINGBAT=\"unknown\">[file tail $entry]\n"
		}
	    }
	}
    } else {
	append listing "<LI>$what is empty\n"
    }
 
    append listing "
</UL>
</BODY>
</HTML>
"
    return $listing
}

# DirlistCompare --
#
# Utility procedure for case-insensitive filename comparison.
# Suitable for use with lsort
 
proc DirlistCompare {a b} {
    string compare [string tolower $a] [string tolower $b]
}
 

