# Snmp editor plugin

proc Plugin_Hit {win x y} {
    if {![Input_Edit $win]} {
	Status $win "Read-only mode"
	return
    }
    set ix [$win index @$x,$y]
    set tags [Mark_FullStack $win $ix all]
    set i [lsearch -glob $tags x-webtk*]
    if {$i < 0} {
	return
    }
    set tag [lindex $tags $i]
    Mark_SplitTag $tag htag param
    lassign {start end} [Edit_CurrentRange $win H:$tag $ix]
    set plugin generic
    HMextract_param $param plugin
    if {[string length $start] > 0} {
	Plugin_$plugin $win $start $end
    }
}
proc Plugin_Snmp {win start end} {
    set text [$win get $start $end]
    set command ""
    regexp {\[(.+)\]} $text x command
    Status $win $command
    set newcmd [Property_Display $win $command]
    if {[string length $newcmd]} {
	Undo_Mark $win Plugin_Snmp
	Text_MarkSet $win insert $start
	Edit_RemoveHtml $win $start $end
	InputSetTags $win force
	Input_Html $win "<x-webtk plugin=Snmp>\[$newcmd\]</x-webtk>"
	Undo_Mark $win Plugin_Snmp
    }
}


Property_Add MibTable "List the SNMP information below a given node" {
    {name	mibname		system	"SNMP node name" \
"Help for SNMP node name"}
    {-submit	text Update	"Submit button label" \
"This is the label on the submit button at the bottom of the table."}
    {-caption	text		{}	"Table caption" \
"Table caption to display."}
   {-writeOnly boolean		0	"Show writable parameters" \
"This suppresses the display of read-only MIB items."}
   {-description boolean	0	"Show MIB description" \
"Display the extended discription of the MIB data item."}
   {-ident	boolean		1	"Show MIB name" \
"Display the symbolic name of the MIB data item."}
   {-readOnly	boolean		0	"Show readonly parameters" \
"List parameters you cannot modify."}
   {-matchName regexp		{}	"Pattern to match names" \
"Regular expression to match MIB names.  If you select the
Not button, then the pattern specifies things to exclude."}
   {-matchValue regexp		{}	"Pattern to match values" \
"Regular expression to match MIB values.  If you select the
Not button, then the pattern specifies things to exclude."}
}

Property_Add PortView "View one or more ports" {
    {which	text		all	"Port to view" \
"all - view all ports
default - view current port
number - view port specified by a number "}
   {-inactive boolean		0	"Show inactive ports" \
"Active ports are ports with output traffic greater than zero."}
   {-style {enum short cat1900_A}		short	"What view to select" \
"short - short generic port information
cat1900_A - device specific information."}
}

Property_Add PortViewDetails "Detailed information about a port" {
    {mib	mibname		swPortEntry	"Mib Symbol" \
"Name of a MIB node corresponding to a port"}
    {-submit	text Update	"Submit button label" \
"This is the label on the submit button at the bottom of the table."}
    {-port	text		default		"Port to view" \
"Which port.
default - the current port.
number - a particular port."}
   {-writeOnly boolean		0	"Show writable parameters" \
"This suppresses the display of read-only MIB items."}
   {-description boolean	0	"Show MIB description" \
"Display the extended discription of the MIB data item."}
   {-ident	boolean		1	"Show MIB name" \
"Display the symbolic name of the MIB data item."}
   {-readOnly	boolean		0	"Show readonly parameters" \
"List parameters you cannot modify."}
   {-matchName regexp		{}	"Pattern to match names" \
"Regular expression to match MIB names.  If you select the
Not button, then the pattern specifies things to exclude."}
   {-matchValue regexp		{}	"Pattern to match values" \
"Regular expression to match MIB values.  If you select the
Not button, then the pattern specifies things to exclude."}
}

Property_Add Boolean "Display a set of radio buttons" {
    {name	formvar		varname	"Form variable associated with radio buttons" \
"Help for Radio"}
}

Property_Add SetMib "Generate a form element to set a MIB value" {
    {name	mibleaf		system	"SNMP node name" \
"This should a leaf node in the MIB hierarchy."}
}

Property_Add SetMibHidden "Set a MIB value - no HTML appearance" {
    {name	mibleaf		system	"SNMP node name" \
"This should a leaf node in the MIB hierarchy."}h
}

Property_Add DisplayMib "Display a MIB property" {
    {name	mibleaf		system	"SNMP node name" \
"This should a leaf node in the MIB hierarchy."}
    {-type	{enum id value description type access choices full name} value	"Display type" \
"id	The MIB object ID number.
value	The value from the device.
description	The description of the MIB item.
type	The MIB datatype of the item.
access	The read/write permissions of the item.
choices	A list of possible values.
full	The very.long.mib.name.
name	The short MIB name."}
    {-group	group		{}	{State group}}

}

Property_Add Select "Selection of Mib properties" {
    {name	formname	mib	"Form variable" \
"This should a leaf node in the MIB hierarchy."}
}

Property_Add FormVar "Value of a form parameter " {
    {name	formvar	x	"Parameter Name" \
"This is the name of a form item.  The value of this
form item, if any, is returned."}
}


Property_Add Discover "Discover SNMP Agents" {
    {delay	integer		5	"SNMP packet delay"
"The discovery process sends a lot of packets.  Increasing the delay,
which is in milliseconds, between packets will reduce the burst load, 
but increase the time needed for discovery."}
    {window	integer		255	"SNMP window"
"The window limits the number of outstanding SNMP requests.
Increasing the window causes a bigger burst on the network."}
    {retries	integer		2	"SNMP retries"
"The retry number controls how many attempts are made to
contact each address during discovery."}
    {timeout	integer		2	"SNMP timeout"
"The timeout indicates how many seconds discovery will wait
for a response when contacting an address."}

}
Property_Add DiscoverControl "Discovery Parameters" {
    {delay	integer		5	"SNMP packet delay"
"The discovery process sends a lot of packets.  Increasing the delay,
which is in milliseconds, between packets will reduce the burst load, 
but increase the time needed for discovery."}
    {window	integer		255	"SNMP window"
"The window limits the number of outstanding SNMP requests.
Increasing the window causes a bigger burst on the network."}
    {retries	integer		2	"SNMP retries"
"The retry number controls how many attempts are made to
contact each address during discovery."}
    {timeout	integer		2	"SNMP timeout"
"The timeout indicates how many seconds discovery will wait
for a response when contacting an address."}

}
