# bindings.tcl
# bindings for the editor
# The HText bindtag is used for edit operations.
# The TSelect bindtag is used for selections.
# The TScroll bindtag is used for scrolling.

# SEE ALSO the bindings defined for menus in defaults.app

# The Selection and insert-setting bindings are primarily OK.
# Copy these from the Text to the TSelect binding class
foreach event {
	B1-Leave B1-Enter B1-Motion
	Double-Button-1
	Shift-Button-1 Double-Shift-Button-1 Triple-Shift-Button-1} {
    bind TSelect <$event> [bind Text <$event>]
}

bind TSelect <Button-1> "
    [bind Text <Button-1>]
    Input_StartSelection %W
"

# The only trick is that we adust the insert position and the selection
# boundaries so they avoid decorative white space.

bind TSelect <ButtonRelease-1> "
    [bind Text <ButtonRelease-1>]
    Input_FinishSelection %W
"

# For debugging
bind TSelect <Control-Button-1> {
    foreach m [Mark_Find %W @%x,%y] {
	puts "$m [Mark_Htag %W $m]"
    }
    break
}

# Select an HTML paragraph
bind TSelect <Triple-Button-1> {Input_SelectNode %W @%x,%y ; break}

# Middle-button scrolling bindings

foreach event {<Button-2> <B2-Motion>} {
    bind TScroll $event [bind Text $event]
}

# Paste HTML
bind HText <ButtonRelease-2> {
    if !$tkPriv(mouseMoved) {
	Input_PasteSelection %W %x %y
    }
}

# Keyboard bindings

bind HText <Key> {
    if {"%A" != "{}"} {
	Input %W %A
    }
}
# These shadow the <Key> binding so these are not inserted
bind HText <Meta-Key> { }
bind HText <Control-Key> { }
bind HText <Alt-Key> { }
bind HText <Escape> { }
bind HText <KP_Enter> { }

# Deletion has to remove the marks that indicate where html tags are.

foreach x {<Delete> <Control-d>} {
    bind HText $x "
	BindDelete %W $x
	break
    "
}
foreach x {<BackSpace> <Control-h>} {
    bind HText $x "
	BindBackspace %W HText $x
	break
    "
}

proc BindDelete {win event} {
    Edit_Delete $win
    update;	# Do a lot of breaks
}
proc BindBackspace {win bindtag event} {
    Edit_Backspace $win
    update;	# Do a lot of breaks
}

# Cursor Motion

foreach x {<Key-Left> <Control-b>} {
    bind HText $x {Input_MoveInsert %W "insert -1 char" ; break}
}
foreach x {<Key-Right> <Control-f>} {
    bind HText $x {Input_MoveInsert %W "insert +1 char" ; break}
}
foreach x {<Key-Up> <Control-p>} {
    bind HText $x {Input_MoveInsert %W "insert -1 line" ; break}
}
foreach x {<Key-Down> <Control-n>} {
    bind HText $x {Input_MoveInsert %W "insert +1 line" ; break}
}

bind HText <Control-a> {Input_MoveInsert %W "insert linestart" ; break}
bind HText <Control-e> {Input_MoveInsert %W "insert lineend" ; break}

bind HText <Key-Home> {Input_MoveInsert %W "1.0" ; break}
bind HText <Key-End> {Input_MoveInsert %W "end" ; break}

bind HText <Key-Prior> "
    [bind Text <Key-Prior>]
    Text_MarkSet %W insert \[Input_Adjust %W]
    break
    "
bind HText <Key-Next> "
    [bind Text <Key-Next>]
    Text_MarkSet %W insert \[Input_Adjust %W]
    break
    "

# These bindings promote/demote list items (nesting levels)
bind HText <Tab> 	{Input_Tab %W; break}
bind HText <Shift-Tab>	{Input_ShiftTab %W; break}

# Hitting return "does the right thing" depending on context
bind HText <Return> {Input_Return %W ; break}

# Control-return always inserts a <p> tag
bind HText <Control-Return> {Input_P %W ; break}

# Shift-return always inserts a <br> tag
bind HText <Shift-Return> {Input_Break %W ; break}

# Random bindings
# TSelect is used for things in both edit and browse mode

bind TSelect <Escape>h	{Mark_ToggleHtml %W ; break}
bind TSelect <Escape>e	{Input_Mode %W 1 ; break}
bind TSelect <Escape>b	{Input_Mode %W 0 ; break}
bind TSelect <Key-Next> {%W yview scroll 1 page}
bind TSelect <Key-Prior> {%W yview scroll -1 page}
bind TSelect <End> {%W yview end}
bind TSelect <Home> {%W yview 0.0}

# HText is only for edit mode

global tk_version	;# sourced inside a procedure
if {$tk_version >= 4.2} {
    # Virtual Event Bindings
    bind HText <<Undo>> {Undo %W}
    bind HText <<Cut>> {SelCut %W}
    bind HText <<Paste>> {SelPaste %W}
    bind TSelect <<Copy>> {SelCopy %W}
#    bind HText <<Save>> {File_Save %W}
}
# Sun keyboard bindings
catch {bind TSelect <Key-F16> {SelCopy %W}}
catch {bind HText <Key-F20> {SelCut %W}}
catch {bind HText <Key-F18> {SelPaste %W}}

bind HText <Control-space> {Input_Html %W {&nbsp;}}

# HCmd is for browse mode bindings.

bind HCmd <Key-space> {%W yview scroll 1 page}
bind HCmd <Key-BackSpace> {%W yview scroll -1 page}

