#!/depot/path/expect

# This is a CGI script that demonstrates file uploading.

package require cgi

cgi_eval {
    source example.tcl

    proc showfile {v} {
	catch {
	    set server [cgi_import_filename -server $v]
	    set client [cgi_import_filename -client $v]
	    if [string length $client] {
		h4 "Uploaded: $client, contents:"
		cgi_preformatted {puts [exec od -c $server]}
	    }
	    exec /bin/rm -f $server
	}
    }

    cgi_input

    cgi_head {
	cgi_title "File binary upload demo"
    }
    cgi_body {
	showfile file1
	showfile file2

	cgi_form uploadbin enctype=multipart/form-data {
	    p "Select up to two files to upload"
	    cgi_file_button file1; br
	    cgi_file_button file2; br
	    cgi_submit_button =Upload
	}
    }
}

