/*
 * genintrep.h --
 *
 *	Internal representation of GenObject instances.
 *
 *	Applications should not need to include this file. If you are
 *	including this file in your code that builds an extension on
 *	top of GenObject, you are doing something wrong!
 *
 * Copyright (c) 2000-2003 JYL Software, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__GENINTREP_H__
#define __GENINTREP_H__

/*
 * Routines used across the GenObject package which are not intended to
 * be used by applications that extend GenObject.
 */

extern void		GenObjectIncrRefcount(GO_InternalRep *ptr2);
extern void		GenObjectDecrRefcount(GO_InternalRep *ptr2);
extern GO_InternalRep * NewGenObjectInternalRep(GO_Extension *extPtr,
						Tcl_Interp *interp,
						void *data);
extern void		GenObjectMakeTclCommand(GO_InternalRep *ptr2);

#endif	/* __GENINTREP_H__ */
