/*
 * testsvisitor.cpp --
 *
 * Tests of the e4_StorageVisitor class.
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#ifndef	_WIN32
#include <unistd.h>
#endif
#include "test.h"

#define TSV_STORAGELIMIT	16

static int
test_svisitor1()
{
    e4_Storage sarray[TSV_STORAGELIMIT];
    e4_Storage svisit;
    int i = 0;
    char buf[32];

    /*
     * Test the constructor.
     */

    for (i = 0; i < TSV_STORAGELIMIT; i++) {
	sprintf(buf, "foo%d.db", i);

	e4_Storage s;
	
	if (!clean_storage(buf, s)) {
	    fprintf(stderr, "test svisitor1 failed (step 1.0.%d)\n", i);
	    return 1;
	}
	if (!s.IsValid()) {
	    fprintf(stderr, "test svisitor1 failed (step 1.1.%d)\n", i);
	    return 1;
	}
	sarray[i] = s;
	if (!sarray[i].IsValid()) {
	    fprintf(stderr, "test svisitor1 failed (step 1.2.%d)\n", i);
	    return 1;
	}
    }
    e4_StorageVisitor sv;
    if (sv.IsDone()) {
	fprintf(stderr, "test svisitor1 failed (step 2)\n");
	return 1;
    }
    for (i = 0; i < TSV_STORAGELIMIT; i++, sv.NextStorage(svisit)) {
	if (!sv.CurrentStorage(svisit)) {
	    fprintf(stderr, "test svisitor1 failed (step 3.1.%d)\n", i);
	    return 1;
	}
	if (!svisit.IsValid()) {
	    fprintf(stderr, "test svisitor1 failed (step 3.2.%d)\n", i);
	    return 1;
	}
    }
    if (!sv.IsDone() || (i != TSV_STORAGELIMIT)) {
	fprintf(stderr, "test svisitor1 failed (step 4, i = %d)\n", i);
	return 1;
    }
    for (i = 0; i < TSV_STORAGELIMIT; i++) {
	sarray[i].Delete();
	if (sarray[i].IsValid()) {
	    fprintf(stderr, "test svisitor1 failed (step 5.%d)\n", i);
	    return 1;
	}
    }
    e4_StorageVisitor sv1;
    if (!sv1.IsDone()) {
	fprintf(stderr, "test svisitor1 failed (step 6)\n");
	return 1;
    }

    return 0;
}

static int
test_svisitor2()
{
    e4_Storage sarray[TSV_STORAGELIMIT];
    e4_Storage svisit, s2, s3;
    int i = 0;
    char buf[32];

    /*
     * Test assignment and comparison operators.
     */

    for (i = 0; i < TSV_STORAGELIMIT; i++) {
	sprintf(buf, "foo%d.db", i);

	e4_Storage s;

	if (!clean_storage(buf, s)) {
	    fprintf(stderr, "test svisitor2 failed (step 1.0.%d)\n", i);
	    return 2;
	}
	if (!s.IsValid()) {
	    fprintf(stderr, "test svisitor2 failed (step 1.1.%d)\n", i);
	    return 2;
	}
	sarray[i] = s;
	if (!sarray[i].IsValid()) {
	    fprintf(stderr, "test svisitor2 failed (step 1.2.%d)\n", i);
	    return 2;
	}
    }
    e4_StorageVisitor sv;
    if (sv.IsDone()) {
	fprintf(stderr, "test svisitor2 failed (step 2)\n");
	return 2;
    }
    for (i = 0; i < 3; i++, sv.NextStorage(svisit)) {
	if (!sv.CurrentStorage(svisit)) {
	    fprintf(stderr, "test svisitor2 failed (step 3.%d)\n", i);
	    return 2;
	}
    }
    e4_StorageVisitor sv1 = sv;
    for (i = 3; !sv.IsDone(); i++, sv.NextStorage(svisit)) {
	if (!sv.CurrentStorage(svisit)) {
	    fprintf(stderr, "test svisitor2 failed (step 4.%d)\n", i);
	    return 2;
	}
    }
    if (i != TSV_STORAGELIMIT) {
	fprintf(stderr, "test svisitor2 failed (step 5)\n");
	return 2;
    }
    for (i = 3; !sv1.IsDone(); i++, sv1.NextStorage(svisit)) {
	if (!sv1.CurrentStorage(svisit)) {
	    fprintf(stderr, "test svisitor2 failed (step 6.%d)\n", i);
	    return 2;
	}
    }
    if (i != TSV_STORAGELIMIT) {
	fprintf(stderr, "test svisitor2 failed (step 7)\n");
	return 2;
    }
    if (sv != sv1) {
	fprintf(stderr, "test svisitor2 failed (step 8)\n");
	return 2;
    }
    e4_StorageVisitor sv2, sv3;

    for (i = 0; 
	 !sv2.IsDone() && !sv3.IsDone(); 
	 i++, sv2.NextStorage(s2), sv3.NextStorage(s3)) {
	if (!sv2.CurrentStorage(s2) || !sv3.CurrentStorage(s3)) {
	    fprintf(stderr, "test svisitor2 failed (step 9.1.%d)\n", i);
	    return 2;
	}
	if (sv2 != sv3) {
	    fprintf(stderr, "test svisitor2 failed (step 9.2.%d)\n", i);
	    return 2;
	}
	if (sv2 == sv3) {
	} else {
	    fprintf(stderr, "test svisitor2 failed (step 9.3.%d)\n", i);
	    return 2;
	}
    }
    if (i != TSV_STORAGELIMIT) {
	fprintf(stderr, "test svisitor2 failed (step 10)\n");
	return 2;
    }
    for (i = 0; i < TSV_STORAGELIMIT; i++) {
	sarray[i].Delete();
	if (sarray[i].IsValid()) {
	    fprintf(stderr, "test svisitor2 failed (step 11.%d)\n", i);
	    return 2;
	}
    }

    return 0;
}

int
test_storagevisitor()
{
    int result = 0;

    fprintf(stderr, "Running e4_StorageVisitor tests: ");
    result = test_svisitor1();
    if (result != 0) {
	return result;
    }
    fprintf(stderr, ".");
    result = test_svisitor2();
    if (result != 0) {
	return result;
    }
    fprintf(stderr, ".\n");
    return 0;
}
