#   @(#)$Id: esql.mk,v 1.1.1.1 2000/03/01 17:53:40 stanton Exp $
#
#   @(#)$Product: ISQLTCL Version 5.00a1 (1999-11-24) $
#
#   Makefile for INFORMIX ESQL/C Compilation
#--------------------------------------------------------------------------
# Note that this file does not define any targets; it only defines
# compilation rules and macros.
#--------------------------------------------------------------------------

###############################################################################
# Compilers and flags
###############################################################################

# ESQL/C Compiler
ESQL_EC_CMD     = esql
ESQL_EC_ENV     = INFORMIXC="${CC}"
ESQL_EC_FLAGS   =
ESQL_EC_LDFLAGS = ${LDFLAGS}

# Complete commands for compiling and linking -- seldom changed
ESQL            = ${ESQL_EC_ENV} ${ESQL_EC_CMD} ${ESQL_EC_FLAGS}

# Basic Unix file commands
RM              = rm -f       # Delete files

###############################################################################
# Define suffixes which are recognised.
ESQL_SUFFIXES   = .ec
.SUFFIXES:	${ESQL_SUFFIXES}

########################################################################
# If your version of MAKE defines the macro SUFFIXES with its default
# list of suffixes, then you can use the following two lines instead.
# It ensures that the ESQL rules take precedence over any other rules.
# If the suffix list is not cleared and there are two files, file01.ec
# and file01.c, in the directory, MAKE will compile the object file
# file01.o from file01.c rather than file01.ec.  Rewriting the suffix
# list prevents this problem.
# Solaris MAKE does define SUFFIXES; most other versions do not.
# Note that i4gl.mk defines ESQL/C rules too.
########################################################################
#.SUFFIXES:
#.SUFFIXES: ${ESQL_SUFFIXES} ${SUFFIXES}

# Rules for compiling ESQL/C
.ec:
	${ESQL} -o $@ $< ${ESQL_EC_LDFLAGS}
	${RM} $*.[co]

.ec.o:
	${ESQL} -c $<
	${RM} $*.c
