# PROVIDE RPC Client Services
# Created: Wed Apr 10 09:16:40 EDT 1996
# Version 1.0
# Functions available:
# set handle [rpcopen server|server@server|server@server]
# rpc $handle tcl_function|tcl_call ..
# e.g. rpc $handle eval {global x; set x 1}
# To close connection, use
# rpc $handle
# To open a handle to the local machine use
# rpcopen "" which will bypass sockets completely


if {"[info command getenv]" == ""} {
	proc getenv {var} {
		global env
		if {[info exists env($var)]} {
			return $env($var)
		}
		return ""
	}
}
proc send_command {handle cmd args} {
	global menu
	set args [lindex $args 0]
	set len [string length "$args"]
	if {$menu(debug) == 1} {
		puts $menu(dbgfp)\
		"[pid] : SENDING COMMAND [format "%06d" $len] cmd {$cmd} {$args}"
		flush $menu(dbgfp)
	}
	puts -nonewline $menu($handle,conn) [format "%-1.1s%06d" $cmd $len]
	puts -nonewline $menu($handle,conn) "$args"
	flush $menu($handle,conn)
	set len [read $menu($handle,conn) 7]
	set control [string range $len 0 0]
	scan $len "%*c%d" len
	if {$menu(debug) == 1} {
		puts $menu(dbgfp) "[pid] : READING len '$len' control '$control'"
		flush $menu(dbgfp)
	}
	if {[catch {read $menu($handle,conn) $len} out] != 0} {
		if {$menu(debug) == 1} {
			puts $menu(dbgfp) "[pid] : READERR: $out"
			flush $menu(dbgfp)
		}
		close $menu($handle,conn)
		set menu($handle,state) 0
		foreach name $menu($handle,names) {
			unset menu($handle,$name)
		}
		error $out
	}
	if {$control == "F"} {
		if {$menu(debug) == 1} {
			puts $menu(dbgfp) "[pid] : CONTROL F: $out"
			flush $menu(dbgfp)
		}
		close $menu($handle,conn)
		set menu($handle,state) 0
		foreach name $menu($handle,names) {
			unset menu($handle,$name)
		}
	} elseif {$control == "X"} {
		if {$menu(debug) == 1} {
			puts $menu(dbgfp) "[pid] : CONTROL X: $out"
			flush $menu(dbgfp)
		}
		close $menu($handle,conn)
		set menu($handle,state) 0
		foreach name $menu($handle,names) {
			unset menu($handle,$name)
		}
	} elseif {$control == "E"} {
		if {$menu(debug) == 1} {
			puts $menu(dbgfp) "[pid] : CONTROL E: $out"
			flush $menu(dbgfp)
		}
		error $out
	} elseif {$control == "L"} {
		if {$menu(debug) == 1} {
			puts $menu(dbgfp) "[pid] : CONTROL L: $out"
			flush $menu(dbgfp)
		}
		return $out
	} else {
		return $out
	}
}
proc rpcopen {server} {
	global menu

	set idebug [getenv RPCDEBUG]
	set menu(debug) 0
	if {$idebug == "1"} {
		set menu(debug) 1
		set menu(dbgfile) [getenv RPCDEBUGFILE]
		if {$menu(dbgfile) == ""} {
			set menu(dbgfile) /tmp/rpcdbg.2
		}
		set menu(dbgfp) [open $menu(dbgfile) a]
		flush $menu(dbgfp)
	}
	# Get server name and socket name from mach1:7098@mach2@mach3:7098
	# as mach1 and 7098
	# If socket is not specified use 7098
	if {$menu(debug) == 1} {
		puts $menu(dbgfp) "[pid] : GOT rpcopen $server"
		flush $menu(dbgfp)
	}
	set slist [string trim [split $server "@"]]
	set proxy 0
	if {[llength $slist] > 1} {
		set proxy 1
		if {$menu(debug) == 1} {
			puts $menu(dbgfp) "[pid] : proxy is 1"
			flush $menu(dbgfp)
		}
	}
	set slist [string trim [split [lindex $slist 0] ":"]]
	set sname [lindex $slist 0]
	set sock [lindex $slist 1]
	if {$sock == ""} {set sock 7098}
	if {$menu(debug) == 1} {
		puts $menu(dbgfp) "[pid] : CALLING socket $sname $sock"
		flush $menu(dbgfp)
	}
	set local 0
	if {$sname == ""} {
		error "NO RPCSERVER SPECIFIED !"
	}
	if {$sname == "local"} {
		set fp local
		set local 1
	} else {
		set fp [socket $sname $sock]
	}
	if {![info exists menu(tot)]} {
		set menu(tot) 0
	} else {
		incr menu(tot)
	}
	set tot $menu(tot)
	set menu(rpc$tot,names) "conn proxy server sock state isproxy"
	set menu(rpc$tot,conn) $fp
	set menu(rpc$tot,proxy) $server
	set menu(rpc$tot,server) $sname
	set menu(rpc$tot,sock) $sock
	if {$local == 1} {
		set menu(rpc$tot,state) 2
	} else {
		set menu(rpc$tot,state) 1
	}
	set menu(rpc$tot,isproxy) 0
	if {$proxy == 1} {
		set menu(rpc$tot,isproxy) 1
	}
	if {$menu(rpc$tot,state) == 1} {
		fconfigure $fp -translation binary
		if {[catch {send_command rpc$tot P $server} ret] != 0} {
			set handle rpc$tot
			close $menu($handle,conn)
			set menu($handle,state) 0
			foreach name $menu($handle,names) {
				unset menu($handle,$name)
			}
			error $ret
		}
	}
	return rpc$tot
}
proc rpcexists {handle} {
	global menu
	if {![info exists menu($handle,state)]} {
		return 0
	}
	if {$menu($handle,state) < 1} {
		return 0
	}
	return $menu($handle,state)
}
proc rpcclose {handle} {
	global menu
	if {![info exists menu($handle,state)]} {
		error "$handle: not open"
	}
	if {$menu($handle,state) == 2} {
		set menu($handle,state) 0
		foreach name $menu($handle,names) {
			unset menu($handle,$name)
		}
		return ""
	}
	if {$menu($handle,state) != 1} {
		error "$handle: not currently open"
	}
	send_command $handle " " ""
}
proc rpc {handle args} {
	global menu 
	if {$handle == ""} {set handle $menu(rpchandle)}
	if {![info exists menu($handle,state)]} {
		error "$handle: not open"
	}
	if {$menu($handle,state) == 2} {
		if {[string length $args] == 0} {
			set menu($handle,state) 0
			foreach name $menu($handle,names) {
				unset menu($handle,$name)
			}
			return ""
		}
		return [eval $args]
	}
	if {$menu($handle,state) != 1} {
		error "$handle: not currently open"
	}
	send_command $handle " " $args
}
proc _sql {args} {
	global menu
	if {[info exists menu(rpchandle)] && [rpcexists $menu(rpchandle)]} {
		return [rpc "" eval sql $args]
	}
	if {![info exists menu(sqlhandle)] || ![rpcexists $menu(sqlhandle)]} {
		global env
		if {[getenv ISTARSERVER] == ""} {
			error "NO ISTARSERVER specified !"
		}
		set sock [getenv ISTARSOCKET]
		if {$sock != ""} {
			set server "$env(ISTARSERVER):$sock"
		} else {
			set server "$env(ISTARSERVER)"
		}
		set menu(sqlhandle) [rpcopen $server]
	}
	rpc $menu(sqlhandle) eval sql $args
}

proc rpcinit {} {
	global env menu
	set menu(rpcserver) [getenv RPCSERVER]
	if {$menu(rpcserver) == ""} {set menu(rpcserver) local}
	set menu(rpchandle) [rpcopen $menu(rpcserver)]
}


# Examples:
# set handle [rpcopen vista]
# rpc $handle eval {global x; set x 12}
# rpc $handle eval {global x; puts "x is $x"; incr x }
# rpc $handle
