#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

# canvItems.tcl
#
# Modified from original demo
#
# jeff at hobbs org, crrw@gmx.de
#
# RCS: @(#) $Id: canvItems.tcl,v 1.2 2005/07/12 23:17:07 hobbs Exp $
#

source [file join [file dirname [info script]] load.tcl]
eval destroy [winfo children .]
raise .

set here	[file dirname [info script]]
set xbm		$here/m128_000.xbm

set SVAL { 11 22 33 44 55 66 77 88 99 }

label .l0 -width 128 -height 128 -bitmap @$xbm -relief groove
pack .l0 -side left

canvas .c0 -width 80 -height 80 \
	-insertwidth 0 		\
	-highlightthickness 0	\
	-selectborderwidth 0	\
	-borderwidth 2		\
	-relief ridge

place .c0 -in .l0  -relx .5 -rely .5 -anchor c

.c0 create stripchart 3 3 80 80 -tags st	\
        -background     "#b7c0d7"       \
        -fill           slategray3      \
        -jumpscroll     1               \
        -outline        black           \
        -scaleline      blue            \
        -stripline      red             \
        -selected       1               \
        -values         $SVAL

.c0 create text 40 40 -text [info patchlevel] -fill cyan -tags text

label .l1 -width 128 -height 128 -bitmap @$xbm -relief groove
pack .l1 -side left
canvas .c1 -width 80 -height 80 \
        -insertwidth 0          \
        -highlightthickness 0   \
        -selectborderwidth 0    \
        -borderwidth 2          \
        -relief ridge

place .c1 -in .l1 -relx .5 -rely .5 -anchor c

.c1 create barchart 3 3 30 80 -tags bar1\
        -background     "#b7c0d7"       \
        -scalevalue     10.0            \
        -autocolor 1                    \
        -selected  1                    \
        -outline   black                \
	-barline yellow			\
        -scalelinestyle 0

.c1 create barchart 53 3 80 80 -tags bar2\
        -background     "#b7c0d7"       \
        -scalevalue     10.0            \
        -autocolor 1                    \
        -selected  1                    \
        -outline   black                \
	-fill	   	"#b7c0d7"	\
	-barline red			\
        -scalelinestyle 22

label .l2 -width 128 -height 128 -bitmap @$xbm -relief groove
pack .l2 -side left
canvas .c2 -width 80 -height 80 \
        -insertwidth 0          \
        -highlightthickness 0   \
        -selectborderwidth 0    \
        -borderwidth 2          \
        -relief ridge

place .c2 -in .l2 -relx .5 -rely .5 -anchor c

if {[catch {
    .c2 create sticker  3 3 80 80 -tags stick \
	    -text	"Tcl/Tk" 	\
	    -space	0		\
	    -color	red		\
	    -outline	red		\
	    -font	{Helvetica 14 bold} \
	    -fill	""		\
	    -stipple	""		\
	    -bar	blue		\
	    -orient	vertical	\
	    -anchor	s		\
	    -relheight	1.0		\
	    -relwidth	.15		\
	    -relx	.1		\
	    -rely	.0
}]} {
    .c2 create text 40 10 -text "No Sticker Item"
}

bind .c0 <1> 	"c_do"

proc c_do {} {
    .c0 itemconfig st -values   [expr {rand()*100}]
    .c1 itemconfig bar1 -values [expr {rand()*10}]
    .c1 itemconfig bar2 -values [expr {rand()*10}]
    .c2 itemconfig stick -rely [expr {rand()*100*0.01}]
}

proc c_run {{delay 100}} {
    if {[winfo exists .c0]} {
	c_do
	after $delay [info level 0]
    }
}

#---

c_run

bind .  <q> { exit }
