# Regexp chapter

# This script extracts options from the Tk man page.
# I used it to set up a table of what widgets have what attributes

proc ExtractOptions { file } {
    set in [open $file]
    set state header
    set widget [file rootname $file]
    puts stdout [string toupper $widget]
    while {[gets $in line] >= 0} {
	switch -- $state {
	    standard { 
		if [regexp {^\\fB.*\\fR$} $line] {
		    foreach word [split $line] {
			regsub -all {(\\fB|\\fR)} $word {} attr
			puts stdout [format "%-15s %s" $widget $attr]
		    }
		}
	    }
	    specific {
		if [regexp {^Name:[	]*\\fB(.+)\\fR} $line match attr] {
		    puts stdout [format "%-15s %s" $widget $attr]
		}
	    }
	}
	switch -regexp -- $line {
	    "STANDARD OPTIONS" {
		set state standard
	    }
	    "WIDGET-SPECIFIC OPTIONS" {
		set state specific
	    }
	    "DESCRIPTION" {
		break
	    }
	}
    }
}
foreach f {bitmap.n button.n canvas.n checkbutton.n entry.n frame.n label.n listbox.n menu.n menubutton.n message.n radiobutton.n scale.n scrollbar.n text.n toplevel.n} {
	ExtractOptions $f
}
