'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/fileutil/fileutil.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "fileutil" n 1.4 fileutil "file utilities"
.BS
.SH NAME
fileutil \- Procedures implementing some file utilities
.SH "SYNOPSIS"
package require \fBTcl 8\fR
.sp
package require \fBfileutil ?1.4?\fR
.sp
\fB::fileutil::cat\fR \fIfilename\fR\fR
.sp
\fB::fileutil::fileType\fR \fIfilename\fR\fR
.sp
\fB::fileutil::find\fR ?\fIbasedir\fR ?\fIfiltercmd\fR??\fR
.sp
\fB::fileutil::findByPattern\fR \fIbasedir\fR ?\fB-regexp\fR|\fB-glob\fR? ?\fB--\fR? \fIpatterns\fR\fR
.sp
\fB::fileutil::foreachLine\fR \fIvar filename cmd\fR\fR
.sp
\fB::fileutil::grep\fR \fIpattern\fR ?\fIfiles\fR?\fR
.sp
\fB::fileutil::stripN\fR \fIpath\fR \fIn\fR\fR
.sp
\fB::fileutil::stripPwd\fR \fIpath\fR\fR
.sp
\fB::fileutil::touch\fR ?\fB-a\fR? ?\fB-c\fR? ?\fB-m\fR? ?\fB-r\fR \fIref_file\fR? ?\fB-t\fR \fItime\fR? \fIfilename\fR ?\fI...\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This package provides implementations of standard unix utilities.
.TP
\fB::fileutil::cat\fR \fIfilename\fR\fR
A tcl implementation of the UNIX \fBcat\fR command.  Returns the
contents of the specified file. The first argument is the name of the
file to read.
.TP
\fB::fileutil::fileType\fR \fIfilename\fR\fR
An implementation of the UNIX \fBfile\fR command, which uses
various heuristics to guess the type of a file.  Returns a list
specifying as much type information as can be determined about the
file, from most general (eg, "binary" or "text") to most specific (eg,
"gif").  For example, the return value for a GIF file would be "binary
graphic gif".  The command will detect the following types of files:
directory, empty, binary, text, script (with interpreter), executable
elf, graphic gif, graphic jpeg, html, xml (with doctype if available),
message pgp, and link.
.TP
\fB::fileutil::find\fR ?\fIbasedir\fR ?\fIfiltercmd\fR??\fR
An implementation of the unix command \fBfind\fR. Adapted from the
Tcler's Wiki. Takes at most two arguments, the path to the directory
to start searching from and a command to use to evaluate interest in
each file. The path defaults to "\fI.\fR", i.e. the current
directory. The command defaults to the empty string, which means that
all files are of interest. The command takes care \fBnot\fR to
loose itself in infinite loops upon encountering circular link
structures.  The result of the command is a list containing the paths
to the interesting files.
.TP
\fB::fileutil::findByPattern\fR \fIbasedir\fR ?\fB-regexp\fR|\fB-glob\fR? ?\fB--\fR? \fIpatterns\fR\fR
This command is based upon the \fBTclX\fR command
\fBrecursive_glob\fR, except that it doesn't allow recursion over more
than one directory at a time. It uses \fB::fileutil::find\fR
internally and is thus able to and does follow symbolic links,
something the \fBTclX\fR command does not do. First argument is
the directory to start the search in, second argument is a list of
\fIpatterns\fR. The command returns a list of all files reachable
through \fIbasedir\fR whose names match at least one of the
patterns. The options before the pattern-list determine the style of
matching, either regexp or glob. glob-style matching is the default if
no options are given. Usage of the option \fB--\fR stops option
processing. This allows the use of a leading '-' in the patterns.
.TP
\fB::fileutil::foreachLine\fR \fIvar filename cmd\fR\fR
The command reads the file \fIfilename\fR and executes the script
\fIcmd\fR for every line in the file. During the execution of the
script the variable \fIvar\fR is set to the contents of the current
line. The return value of this command is the result of the last
invocation of the script \fIcmd\fR or the empty string if the file was
empty.
.TP
\fB::fileutil::grep\fR \fIpattern\fR ?\fIfiles\fR?\fR
Implementation of \fBgrep\fR. Adapted from the Tcler's Wiki. The
first argument defines the \fIpattern\fR to search for. This is
followed by a list of \fIfiles\fR to search through. The list is
optional and \fBstdin\fR will be used if it is missing. The result
of the procedures is a list containing the matches. Each match is a
single element of the list and contains filename, number and contents
of the matching line, separated by a colons.
.TP
\fB::fileutil::stripN\fR \fIpath\fR \fIn\fR\fR
Removes the first \fIn\fR elements from the specified \fIpath\fR and
returns the modified path. If \fIn\fR is greater than the number of
components in \fIpath\fR an empty string is returned.
.TP
\fB::fileutil::stripPwd\fR \fIpath\fR\fR
If the \fIpath\fR is inside of the directory returned by
[\fBpwd\fR] it is made relative to that directory. In other
words, the current working directory is stripped from the \fIpath\fR.
The possibly modified path is returned as the result of the command.
.TP
\fB::fileutil::touch\fR ?\fB-a\fR? ?\fB-c\fR? ?\fB-m\fR? ?\fB-r\fR \fIref_file\fR? ?\fB-t\fR \fItime\fR? \fIfilename\fR ?\fI...\fR?\fR
Implementation of \fBtouch\fR. Alter the atime and mtime of the
specified files. If \fB-c\fR, do not create files if they do not
already exist. If \fB-r\fR, use the atime and mtime from
\fIref_file\fR. If \fB-t\fR, use the integer clock value
\fItime\fR. It is illegal to specify both \fB-r\fR and
\fB-t\fR. If \fB-a\fR, only change the atime. If \fB-m\fR,
only change the mtime.
.SH "KEYWORDS"
file utilities
