'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/mime/mime.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "mime" n 1.3.2 mime "Mime"
.BS
.SH NAME
mime \- Manipulation of MIME body parts
.SH "SYNOPSIS"
package require \fBTcl\fR
.sp
package require \fBmime ?1.3.2?\fR
.sp
\fB::mime::initialize\fR ?\fB-canonical\fR \fItype/subtype\fR ?\fB-param\fR {\fIkey value\fR}...? ?\fB-encoding\fR \fIvalue\fR? ?\fB-header\fR {\fIkey value\fR}...?? (\fB-file\fR \fIname\fR | \fB-string\fR \fIvalue\fR | \fB-parse\fR {\fItoken1\fR ... \fItokenN\fR})\fR
.sp
\fB::mime::finalize\fR \fItoken\fR ?\fB-subordinates\fR \fBall\fR | \fBdynamic\fR | \fBnone\fR?\fR
.sp
\fB::mime::getproperty\fR \fItoken\fR ?\fIproperty\fR | \fB-names\fR?\fR
.sp
\fB::mime::getheader\fR \fItoken\fR ?\fIkey\fR | \fB-names\fR?\fR
.sp
\fB::mime::setheader\fR \fItoken\fR \fIkey value\fR ?\fB-mode\fR \fBwrite\fR | \fBappend\fR | \fBdelete\fR?\fR
.sp
\fB::mime::getbody\fR \fItoken\fR ?\fB-command\fR \fIcallback\fR ?\fB-blocksize\fR \fIoctets\fR??\fR
.sp
\fB::mime::copymessage\fR \fItoken\fR \fIchannel\fR\fR
.sp
\fB::mime::buildmessage\fR \fItoken\fR\fR
.sp
\fB::mime::parseaddress\fR \fIstring\fR\fR
.sp
\fB::mime::parsedatetime\fR (\fIstring\fR | \fB-now\fR) \fIproperty\fR\fR
.sp
\fB::mime::mapencoding\fR \fIencoding_name\fR\fR
.sp
\fB::mime::reversemapencoding\fR \fIcharset_type\fR\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBmime\fR library package provides the commands to create and
manipulate MIME body parts.
.TP
\fB::mime::initialize\fR ?\fB-canonical\fR \fItype/subtype\fR ?\fB-param\fR {\fIkey value\fR}...? ?\fB-encoding\fR \fIvalue\fR? ?\fB-header\fR {\fIkey value\fR}...?? (\fB-file\fR \fIname\fR | \fB-string\fR \fIvalue\fR | \fB-parse\fR {\fItoken1\fR ... \fItokenN\fR})\fR
This command creates a MIME part and returns a token representing it.
.RS
.IP \(bu
If the \fB-canonical\fR option is present, then the body is in
canonical (raw) form and is found by consulting either the
\fB-file\fR, \fB-string\fR, or \fB-part\fR option.
.sp
In addition, both the \fB-param\fR and \fB-header\fR options may
occur zero or more times to specify \fBContent-Type\fR parameters
(e.g., \fBcharset\fR) and header keyword/values (e.g.,
\fBContent-Disposition\fR), respectively.
.sp
Also, \fB-encoding\fR, if present, specifies the
\fBContent-Transfer-Encoding\fR when copying the body.
.IP \(bu
If the \fB-canonical\fR option is not present, then the MIME part
contained in either the \fB-file\fR or the \fB-string\fR option
is parsed, dynamically generating subordinates as appropriate.
.RE
.TP
\fB::mime::finalize\fR \fItoken\fR ?\fB-subordinates\fR \fBall\fR | \fBdynamic\fR | \fBnone\fR?\fR
This command destroys the MIME part represented by \fItoken\fR. It
returns an empty string.
.sp
If the \fB-subordinates\fR option is present, it specifies which
subordinates should also be destroyed. The default value is
\fBdynamic\fR, destroying all subordinates which were created by
\fB::mime::initialize\fR together with the containing body part.
.TP
\fB::mime::getproperty\fR \fItoken\fR ?\fIproperty\fR | \fB-names\fR?\fR
This command returns a string or a list of strings containing the
properties of a MIME part. If the command is invoked with the name of
a specific property, then the corresponding value is returned;
instead, if \fB-names\fR is specified, a list of all properties is
returned; otherwise, a serialized array of properties and values is
returned.
.sp
The possible properties are:
.RS
.TP
\fBcontent\fR
The type/subtype describing the content
.TP
\fBencoding\fR
The "Content-Transfer-Encoding"
.TP
\fBparams\fR
A list of "Content-Type" parameters
.TP
\fBparts\fR
A list of tokens for the part's subordinates.  This property is
present only if the MIME part has subordinates.
.TP
\fBsize\fR
The approximate size of the content (unencoded)
.RE
.TP
\fB::mime::getheader\fR \fItoken\fR ?\fIkey\fR | \fB-names\fR?\fR
This command returns the header of a MIME part, as a list of strings.
.sp
A header consists of zero or more key/value pairs. Each value is a
list containing one or more strings.
.sp
If this command is invoked with the name of a specific \fIkey\fR, then
a list containing the corresponding value(s) is returned; instead, if
-names is specified, a list of all keys is returned; otherwise, a
serialized array of keys and values is returned. Note that when a key
is specified (e.g., "Subject"), the list returned usually contains
exactly one string; however, some keys (e.g., "Received") often occur
more than once in the header, accordingly the list returned usually
contains more than one string.
.TP
\fB::mime::setheader\fR \fItoken\fR \fIkey value\fR ?\fB-mode\fR \fBwrite\fR | \fBappend\fR | \fBdelete\fR?\fR
This command writes, appends to, or deletes the \fIvalue\fR associated
with a \fIkey\fR in the header. It returns a list of strings
containing the previous value associated with the key.
.sp
The value for \fB-mode\fR is one of:
.RS
.TP
\fBwrite\fR
The \fIkey\fR/\fIvalue\fR is either created or overwritten (the default).
.TP
\fBappend\fR
A new \fIvalue\fR is appended for the \fIkey\fR (creating it as necessary).
.TP
\fBdelete\fR
All values associated with the key are removed (the \fIvalue\fR
parameter is ignored).
.RE
.TP
\fB::mime::getbody\fR \fItoken\fR ?\fB-command\fR \fIcallback\fR ?\fB-blocksize\fR \fIoctets\fR??\fR
This command returns a string containing the body of the leaf MIME
part represented by \fItoken\fR in canonical form.
.sp
If the \fB-command\fR option is present, then it is repeatedly
invoked with a fragment of the body as this:
.nf
  uplevel #0 $callback [list "data" $fragment]
.fi
.sp
(The \fB-blocksize\fR option, if present, specifies the maximum
size of each fragment passed to the callback.)
.sp
When the end of the body is reached, the callback is invoked as:
.nf
  uplevel #0 $callback "end"
.fi
.sp
Alternatively, if an error occurs, the callback is invoked as:
.nf
  uplevel #0 $callback [list "error" reason]
.fi
.sp
Regardless, the return value of the final invocation of the callback
is propagated upwards by mime::getbody.
.sp
If the \fB-command\fR option is absent, then the return value of
\fB::mime::getbody\fR is a string containing the MIME part's entire
body.
.TP
\fB::mime::copymessage\fR \fItoken\fR \fIchannel\fR\fR
This command copies the MIME represented by \fItoken\fR part to the
specified \fIchannel\fR. The command operates synchronously, and uses
fileevent to allow asynchronous operations to proceed
independently. It returns an empty string.
.TP
\fB::mime::buildmessage\fR \fItoken\fR\fR
This command returns the MIME part represented by \fItoken\fR as a
string.  It is similar to \fB::mime::copymessage\fR, only it returns
the data as a return string instead of writing to a channel.
.TP
\fB::mime::parseaddress\fR \fIstring\fR\fR
This command takes a string containing one or more 822-style address
specifications and returns a list of serialized arrays, one element
for each address specified in the argument. If the string contains
more than one address they will be separated by commas.
.sp
Each serialized array contains the properties below. Note that one or
more of these properties may be empty.
.RS
.TP
\fBaddress\fR
local@domain
.TP
\fBcomment\fR
822-style comment
.TP
\fBdomain\fR
the domain part (rhs)
.TP
\fBerror\fR
non-empty on a parse error
.TP
\fBgroup\fR
this address begins a group
.TP
\fBfriendly\fR
user-friendly rendering
.TP
\fBlocal\fR
the local part (lhs)
.TP
\fBmemberP\fR
this address belongs to a group
.TP
\fBphrase\fR
the phrase part
.TP
\fBproper\fR
822-style address specification
.TP
\fBroute\fR
822-style route specification (obsolete)
.RE
.TP
\fB::mime::parsedatetime\fR (\fIstring\fR | \fB-now\fR) \fIproperty\fR\fR
This command takes a string containing an 822-style date-time
specification and returns the specified property as a serialized
array.
.sp
The list of properties and their ranges are:
.RS
.TP
\fBhour\fR
0 .. 23
.TP
\fBlmonth\fR
January, February, ..., December
.TP
\fBlweekday\fR
Sunday, Monday, ... Saturday
.TP
\fBmday\fR
1 .. 31
.TP
\fBmin\fR
0 .. 59
.TP
\fBmon\fR
1 .. 12
.TP
\fBmonth\fR
Jan, Feb, ..., Dec
.TP
\fBproper\fR
822-style date-time specification
.TP
\fBrclock\fR
elapsed seconds between then and now
.TP
\fBsec\fR
0 .. 59
.TP
\fBwday\fR
0 .. 6 (Sun .. Mon)
.TP
\fBweekday\fR
Sun, Mon, ..., Sat
.TP
\fByday\fR
1 .. 366
.TP
\fByear\fR
1900 ...
.TP
\fBzone\fR
-720 .. 720 (minutes east of GMT)
.RE
.TP
\fB::mime::mapencoding\fR \fIencoding_name\fR\fR
This commansd maps tcl encodings onto the proper names for their MIME
charset type.  This is only done for encodings whose charset types
were known.  The remaining encodings return "" for now.
.TP
\fB::mime::reversemapencoding\fR \fIcharset_type\fR\fR
This command maps MIME charset types onto tcl encoding names.  Those
that are unknown return "".
.SH "SEE ALSO"
smtp, pop3, ftp, http
.SH "KEYWORDS"
mail, email, smtp, mime, rfc821, rfc822, internet, net
