
proc addframeURL {args} {
    set optlist {
	{integer} frame
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)"
    }

    if !$opt_found(frame) {
	error "Option -frame must be passed to [lindex [info level 0] 0]"
    }

    set URL &fram=$opt_values(frame)

    return $URL
}

proc addspecURL {args} {
    set URL {}
    set optlist {
	{integer} start
	{integer} end
	{list-of integer} list
	{integer} index
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }

    if {$opt_found(start) && !$opt_found(end)} {
	error "use of option -start must also include use of option -end"
    }
    if {!$opt_found(start) && $opt_found(end)} {
	error "use of option -start must also include use of option -end"
    }

    if {$opt_found(start) && $opt_found(end)} {
	set URL "&rows=$opt_values(start)&rowe=$opt_values(end)"
    }

    if {$opt_found(list)} {
	foreach el $opt_values(list) {
	    set URL "&rown=$el"
	}
    }

    if {$opt_found(index)} {
	set URL "&rown=$opt_values(index)"
    }

    return $URL
}

proc countspecURL {args} {
    set optlist {
	{string} url
	{boolean} list 
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }
    if !$opt_found(url) {
	error "No url passed to [lindex [info level 0] 0]"
    }

    set count 0
    set list {}
    foreach el [split $opt_values(url) &] {
	if {[regexp ^(.*)=(.*) $el null opt value]} {

	    switch $opt {
		rown {
		    incr count
		    lappend list $value
		}
		rows { set start $value }
		rowe {
		    incr count [expr $value - $start + 1]
		    for {set i $start} {$i <= $value} {incr i} {
			lappend list $i
		    }
		}
	    }
	}
    }

    if $opt_found(list) {
	return $list
    } else {
	return $count
    }
}

proc addtagURL {args} {
    set URL {}

    set optlist {
	{string} file
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }

    if $opt_found(names) {
	set URL "$URL&tags"
    }

    if $opt_found(value) {
	set URL "$URL&tagn=$opt_values(value)"
    }

    return $URL
}

proc addfileURL {args} {
    set optlist {
	{string} file
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }

    if !$opt_found(file) {
	error "No file specified!"
    }

    set URL rdf://$opt_values(file)

    return $URL
}
