proc addframeURL {args} {
    level

    set optlist {
	{integer} frame
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)"
    }

    if !$opt_found(frame) {
	error "Option -frame must be passed to [lindex [info level 0] 0]"
    }

    set URL &frm=$opt_values(frame)

    return $URL
}

proc addgrpURL {args} {
    set URL {}
    set optlist {
	{string} group
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }

    if !$opt_found(group) {
	error "[lindex [info level 0] 0] requires a -group option"
    }

    return "&grp=\{$opt_values(group)\}"
}

proc startspecURL {args} {
    return "&grp=\{"
}

proc endspecURL {args} {
    return "\}"
}

proc addconfigURL {args} {
    return &configure=$args
}

proc addspecURL {args} {
    set URL {}
    set optlist {
	{integer} start
	{integer} end
	{list-of integer} list
	{integer} index
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }

    if {$opt_found(start) && !$opt_found(end)} {
	error "use of option -start must also include use of option -end"
    }
    if {!$opt_found(start) && $opt_found(end)} {
	error "use of option -start must also include use of option -end"
    }

    if {$opt_found(start) && $opt_found(end)} {
	if {$opt_values(start) > $opt_values(end)} {
	    set URL {}
	}
	if {$opt_values(start) == $opt_values(end)} {
	    set URL r=$opt_values(start)
	}
	if {$opt_values(start) < $opt_values(end)} {
	    incr opt_values(start) -1
	    incr opt_values(end) 1
	    set URL "r>$opt_values(start)&r<$opt_values(end)"
	}
    }

    if {$opt_found(list)} {
	foreach el $opt_values(list) {
	    append URL "r=$el|"
	}
	set URL [string trim $URL |]
    }

    if {$opt_found(index)} {
	set URL "r=$opt_values(index)"
    }

    return $URL
}

proc countspecURL {args} {
    global wid_path
#    set optlist {
#	{string} url
#	{boolean} list 
#    }
#
#    if ![typedopts $args $optlist opt_found opt_values remains] {
#	puts stderr "$opt_values(_ERROR_)" 
#    }
#    if !$opt_found(url) {
#	error "No url passed to [lindex [info level 0] 0]"
#    }

    return 0
}

proc addtagURL {args} {
    set URL {}

    set optlist {
	{string} file
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }

    if $opt_found(names) {
	set URL "$URL&tags"
    }

    if $opt_found(value) {
	set URL "$URL&tag=$opt_values(value)"
    }

    return $URL
}

proc addfileURL {args} {
    set optlist {
	{string} file
    }

    if ![typedopts $args $optlist opt_found opt_values remains] {
	puts stderr "$opt_values(_ERROR_)" 
    }

    if !$opt_found(file) {
	error "No file specified!"
    }

    set URL rdf://$opt_values(file)

    return $URL
}
