/*
 * e4id.cpp --
 *
 *	Implementation of wrapper classes that wrap around unique IDs
 *	of various types.
 *
 *	Authors: Jacob Levy and Jean-Claude Wippler.
 *		 jyl@best.com	jcw@equi4.com
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "e4graphimpl.h"

/*
 * Implementation of e4_CommonUniqueID.
 */

e4_CommonUniqueID::e4_CommonUniqueID() : ID(E4_INVALIDUNIQUEID), SP(0) {}

e4_CommonUniqueID::e4_CommonUniqueID(const e4_CommonUniqueID &referrer)
    : ID(referrer.ID),
      SP(referrer.SP)
{
}

e4_CommonUniqueID::e4_CommonUniqueID(int uid, int usp)
    : ID(uid),
      SP(usp)
{
}

e4_CommonUniqueID &
e4_CommonUniqueID::operator=(const e4_CommonUniqueID &referrer)
{
   ID = referrer.ID;
   SP = referrer.SP;

   return *this;
}

e4_CommonUniqueID::~e4_CommonUniqueID() {}

bool
e4_CommonUniqueID::operator==(const e4_CommonUniqueID &compared) const
{
    return ((ID == compared.ID) && (SP == compared.SP)) ? true : false;
}

bool
e4_CommonUniqueID::operator!=(const e4_CommonUniqueID &compared) const
{
    return ((ID == compared.ID) && (SP == compared.SP)) ? false : true;
}

/*
 * Wrappper for unique IDs derived from instances of e4_Node.
 */

e4_NodeUniqueID::e4_NodeUniqueID()
    : e4_CommonUniqueID(E4_INVALIDUNIQUEID, 0)
{
}

e4_NodeUniqueID::e4_NodeUniqueID(const e4_NodeUniqueID &referrer)
    : e4_CommonUniqueID(referrer.GetID(), referrer.GetSP())
{
}

e4_NodeUniqueID::e4_NodeUniqueID(int nid, int sp)
    : e4_CommonUniqueID(nid, sp)
{
}

e4_NodeUniqueID &
e4_NodeUniqueID::operator=(const e4_NodeUniqueID &referrer)
{
    SetID(referrer.GetID());
    SetSP(referrer.GetSP());

    return *this;
}

bool
e4_NodeUniqueID::operator==(const e4_NodeUniqueID &compared) const
{
    return ((GetID() == compared.GetID()) && (GetSP() == compared.GetSP()))
	? true : false;
}

bool
e4_NodeUniqueID::operator!=(const e4_NodeUniqueID &compared) const
{
    return ((GetID() == compared.GetID()) && (GetSP() == compared.GetSP()))
	? false : true;
}

/*
 * Wrappper for unique IDs derived from instances of e4_Vertex.
 */

e4_VertexUniqueID::e4_VertexUniqueID()
    : e4_CommonUniqueID(E4_INVALIDUNIQUEID, 0)
{
}

e4_VertexUniqueID::e4_VertexUniqueID(const e4_VertexUniqueID &referrer)
    : e4_CommonUniqueID(referrer.GetID(), referrer.GetSP())
{
}

e4_VertexUniqueID::e4_VertexUniqueID(int vid, int sp)
    : e4_CommonUniqueID(vid, sp)
{
}

e4_VertexUniqueID &
e4_VertexUniqueID::operator=(const e4_VertexUniqueID &referrer)
{
    SetID(referrer.GetID());
    SetSP(referrer.GetSP());

    return *this;
}

bool
e4_VertexUniqueID::operator==(const e4_VertexUniqueID &compared) const
{
    return ((GetID() == compared.GetID()) && (GetSP() == compared.GetSP()))
	? true : false;
}

bool
e4_VertexUniqueID::operator!=(const e4_VertexUniqueID &compared) const
{
    return ((GetID() == compared.GetID()) && (GetSP() == compared.GetSP()))
	? false : true;
}
