/*
 * test.cc --
 *
 * Compile-time test harness for e4Graph.
 *
 * Copyright (c) 2000-2003, JYL Software Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
 * JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "test.h"

/*
 * For Macintosh builds, since this is a console application, we need
 * to include <console.h>.
 */

#if macintosh
#include <console.h>
#endif

bool
clean_storage(const char *name, e4_Storage &ss)
{
    {
        e4_Storage x(name, E4_METAKIT);

	x.Delete();
    }

    e4_Storage s(name, E4_METAKIT);

    ss = s;

    return true;
}

static int
parse_testselection(char *pgm, int ac, char **av) 
{
    int i = 0;
    int len = 0;
    int selection = TEST_NONE;

    for (i = 0; i < ac; i++) {
        if (*av[i] == 'a') {
            return TEST_ALL;
        }
        len = strlen(av[i]);
	if (*av[i] == 'c') {
	    selection |= TEST_CALLBACK;
	    continue;
	}
	if (*av[i] == 'd') {
	    selection |= TEST_DSTRING;
	    continue;
	}
	if (*av[i] == 'D') {
	    selection |= TEST_DETACH;
	    continue;
	}
        if (*av[i] == 's') {
            selection |= TEST_STORAGE;
            continue;
        }
        if (*av[i] == 'v') {
            selection |= TEST_VERTEX;
            continue;
        }
        if (*av[i] == 'n') {
            if (strcmp(av[i], "none") == 0) {
                return TEST_NONE;
            }
            selection |= TEST_NODE;
            continue;
        }
	if (*av[i] == 'r') {
	    selection |= TEST_REFCOUNT;
	    continue;
	}
	if (*av[i] == 'S') {
	    selection |= TEST_SVISITOR;
	    continue;
	}
	if (*av[i] == 'V') {
	    selection |= TEST_VVISITOR;
	    continue;
	}
	if (*av[i] == 'N') {
	    selection |= TEST_NVISITOR;
	    continue;
	}
        fprintf(stderr, "%s: illegal option %s\n", pgm, av[i]);
        return 0;
    }
    return selection;
}

int
main(int ac, char **av)
{
    int result = 0;
    int testselection = 0;

#if macintosh
    ac = ccommand(&av);
#endif
    if (ac == 1) {
        fprintf(stderr, "%s: usage: %s test1 test2 test3 ..\n", av[0], av[0]);
        exit(99);
    }
    testselection = parse_testselection(av[0], ac-1, av+1);
    if ((testselection & TEST_DSTRING) == TEST_DSTRING) {
	result = test_dstring();
    }
    if (result != 0) {
        exit(result);
    }
    if ((testselection & TEST_REFCOUNT) == TEST_REFCOUNT) {
	result = test_refcount();
    }
    if (result != 0) {
	exit(result);
    }
    if ((testselection & TEST_STORAGE) == TEST_STORAGE) {
        result = test_storage();
    }
    if (result != 0) {
        exit(result);
    }
    if ((testselection & TEST_NODE) == TEST_NODE) {
        result = test_node();
    }
    if (result != 0) {
        exit(result);
    }
    if ((testselection & TEST_VERTEX) == TEST_VERTEX) {
        result = test_vertex();
    }
    if (result != 0) {
        exit(result);
    }
    if ((testselection & TEST_SVISITOR) == TEST_SVISITOR) {
	result = test_storagevisitor();
    }
    if (result != 0) {
        exit(result);
    }
    if ((testselection & TEST_NVISITOR) == TEST_NVISITOR) {
	result = test_nodevisitor();
    }
    if (result != 0) {
        exit(result);
    }
    if ((testselection & TEST_VVISITOR) == TEST_VVISITOR) {
        result = test_vertexvisitor();
    }
    if (result != 0) {
	exit(result);
    }
    if ((testselection & TEST_CALLBACK) == TEST_CALLBACK) {
	result = test_callback();
    }
    if (result != 0) {
	exit(result);
    }
    if ((testselection & TEST_DETACH) == TEST_DETACH) {
	result = test_detach();
    }
    if (result != 0) {
	exit(result);
    }

    return 0;
}
