tcltest::test 15.18.1-1 { String + requires a String argument } {
    # Sun seems to have relaxed this so that null is used as type String implicitly
    is_assignable_to T151811 String {null + 1} String {1 + null}
} FAIL

tcltest::test 15.18.1-2 { (String)null denotes String concatenation } {
    is_assignable_to T151812 String {(String)null + 1} String {1 + (String)null}
} PASS

tcltest::test 15.18.1-3 { (String)null + null denotes String concatenation } {
    is_assignable_to T151813 \
        String {null + (String)null} \
        String {(String)null + null} \
        String {(String)null + (String)null}
} PASS

tcltest::test 15.18.1-4 { void + String is invalid } {
    is_assignable_to T151814 \
        String {System.out.println() + ""} \
        String {"" + System.out.println()}
} FAIL

tcltest::test 15.18.1-5 { + operator should be left-associative } {
    constant_expression T151815 \
        {1 + 2 + " fiddlers" == "3 fiddlers"} \
        {"fiddlers " + 1 + 2 == "fiddlers 12"}
} PASS

tcltest::test 15.18.1-6 { + operator and integer constants } {
    constant_expression T151816 \
        {"-12300000" == "" + -12300000} \
        {"-12300000,-50000000" ==
            -12300000 + "," + -50000000}
} PASS

tcltest::test 15.18.1-7 { + operator and long constants } {
    constant_expression T151817 \
        {"-12192592592745" == "" + -12192592592745L} \
        {"-12192592592745,-12192592592745" ==
            -12192592592745L + "," + -12192592592745L}
} PASS



tcltest::test 15.18.1-float-1 { convert denormalized float to String } {
    constant_expression T15181f1 {"" + 1e-44f == "9.8E-45"}
} PASS

tcltest::test 15.18.1-float-2 { convert NaN float to String } {
    constant_expression T15181f2 {"" + Float.NaN == "NaN"} {"" + (-Float.NaN) == "NaN"}
} PASS

tcltest::test 15.18.1-float-3 { convert Infinity float to String } {
    constant_expression T15181f3 {"" + Float.NEGATIVE_INFINITY == "-Infinity"} \
                                 {"" + Float.POSITIVE_INFINITY == "Infinity"}
} PASS

tcltest::test 15.18.1-float-4 { convert min float to String } {
    constant_expression T15181f4 {"" +  Float.MIN_VALUE == "1.4E-45"}
} PASS

tcltest::test 15.18.1-float-5 { convert max float to String } {
    constant_expression T15181f5 {"" +  Float.MAX_VALUE == "3.4028235E38"}
} PASS

tcltest::test 15.18.1-float-6 { conversion of float to String must use as few
        digits after decimal as produce the same float again by rounding } {
    constant_expression T15181f6 \
            {"" + 123456768f == "1.2345677E8"} \
            {"" + 123456776f == "1.23456776E8"} \
            {"" + 123456784f == "1.2345678E8"} \
            {"" + 123456792f == "1.2345679E8"} \
            {"" + 123456800f == "1.234568E8"}
} PASS

tcltest::test 15.18.1-double-1 { convert denormalized double to String } {
    constant_expression T15181d1 {"" + 1e-315 == "1.0E-315"}
} PASS

tcltest::test 15.18.1-double-2 { convert Nan double to String } {
    constant_expression T15181d2 {"" + Double.NaN == "NaN"} {"" + (-Double.NaN) == "NaN"}
} PASS

tcltest::test 15.18.1-double-3 { convert Infinity double to String } {
    constant_expression T15181d3 {"" + Double.NEGATIVE_INFINITY == "-Infinity"} \
                                 {"" + Double.POSITIVE_INFINITY == "Infinity"}
} PASS

tcltest::test 15.18.1-double-4 { convert min double to String } {
    constant_expression T15181d4 {"" + Double.MIN_VALUE == "4.9E-324"}
} PASS

tcltest::test 15.18.1-double-5 { convert max double to String } {
    constant_expression T15181d5 {"" + Double.MAX_VALUE == "1.7976931348623157E308"}
} PASS

tcltest::test 15.18.1-double-6 { NaN != 12.0 } {
    constant_expression T15181d6 {"" + Double.NaN == "NaN"} \
                                 {"" + 12.0 == "12.0"}
} PASS

tcltest::test 15.18.1-double-7 { NaN != 12.0 } {
    constant_expression T15181d7 {"" + 12.0 == "12.0"} \
                                 {"" + Double.NaN == "NaN"}
} PASS
