#!/bin/sh
# The next line is executed by /bin/sh, but not tcl \
  exec wish "$0" ${1+"$@"}

set wish [info nameofexe]
set index 1
foreach demo [glob demo/*.tcl] {
  puts -nonewline "$index.  Demo \"demo/[file tail $demo]\": "
  flush stdout
  if {[catch {exec $wish [file normalize $demo]} error]} {
    puts FAILURE!
    puts "    --> $error"
  } else {
    puts Success!
  }
  incr index
}
exit 0
