#ifndef _TKGSWINDRAWABLE
#define _TKGSWINDRAWABLE

/*
 * Win32 Drawables
 */

/* Object type */
EXTERN TkGS_ObjType *WinDrawableTypePtr;

/* Structure */
typedef struct WinDrawable {
    HWND	hwnd;
    HDC		hdc;
    HPEN	hpen;	/* These 2 attributes hold a Pen and a Brush created */
    HBRUSH	hbrush;	/* with the current GC values: foreground and 
			 * lineWidth for Pen, foreground, background and 
			 * stipple for Brush. When lineWidth is 0 or there 
			 * is no stipple, then we use the Pen and Brush from
			 * the foreground color. */

    TkGSSubFontId subFontId;
			/* The currently selected subfont ID. */
} WinDrawable;

/* Accessors */
#define WinDrawable_InternalRep(intRepPtr) \
    ((WinDrawable *) intRepPtr->value.otherValuePtr)

#define WinDrawable_HWND(intRepPtr) \
    (WinDrawable_InternalRep(intRepPtr)->hwnd)
#define WinDrawable_HDC(intRepPtr) \
    (WinDrawable_InternalRep(intRepPtr)->hdc)
#define WinDrawable_HPEN(intRepPtr) \
    (WinDrawable_InternalRep(intRepPtr)->hpen)
#define WinDrawable_HBRUSH(intRepPtr) \
    (WinDrawable_InternalRep(intRepPtr)->hbrush)
#define WinDrawable_SubFontId(intRepPtr) \
    (WinDrawable_InternalRep(intRepPtr)->subFontId)

#endif /* _TKGSWINDRAWABLE */

