#ifndef _TKGSWININT
#define _TKGSWININT

/*
 * if the BUILD_WinTkGS macro is defined, the assumption is that we are
 * building the dynamic library.
 */

#ifdef BUILD_WinTkGS
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#include "tkgsWinDrawable.h"
#include "tkgsWinColor.h"
#include "tkgsWinFont.h"

#define DECLAREDRAWINGVARS(d, intRepPtr, hdc) \
    register TkGS_InternalRep *intRepPtr  = TkGS_FindInternalRep((TkGS_Obj *) (d), WinDrawableTypePtr); \
    HDC hdc = WinDrawable_HDC(intRepPtr);


/*
 * Text and font primitives.
 */

TkGS_GetFontMetricsProc			WinTkGS_GetFontMetrics;
TkGS_GetActualFontAttributesProc	WinTkGS_GetActualFontAttributes;
TkGS_EnumerateFontFamiliesProc		WinTkGS_EnumerateFontFamiliesUni,
					WinTkGS_EnumerateFontFamiliesSys;
TkGS_FontFamilyExistsProc		WinTkGS_FontFamilyExistsUni,
					WinTkGS_FontFamilyExistsSys;

TkGS_MeasureCharsUniProc		WinTkGS_MeasureCharsUni;
TkGS_DrawCharsUniProc			WinTkGS_DrawCharsUni;

TkGS_MeasureCharsUtfProc		WinTkGS_MeasureCharsUtf;
TkGS_DrawCharsUtfProc			WinTkGS_DrawCharsUtf;

TkGS_TextWidthSysProc			WinTkGS_TextWidthSys;
TkGS_DrawCharsSysProc			WinTkGS_DrawCharsSys;


/*
 * Multi-font Unicode primitives
 */


TkGSGetSubFontProc			WinTkGSGetSubFont;
TkGSSetDrawableSubFontProc		WinTkGSSetDrawableSubFont;
TkGSFontMapLoadPageProc			WinTkGSFontMapLoadPage;
TkGSCanUseFontProc			WinTkGSCanUseFont;
TkGSCanUseFallbackProc			WinTkGSCanUseFallback;
TkGSDefaultSubFontProc			WinTkGSDefaultSubFont;

/*  - Unicode version */

TkGS_MeasureCharsUniProc		WinTkGSSubFontMeasureCharsUni;
TkGS_TextWidthUniProc			WinTkGSSubFontTextWidthUni;
TkGS_DrawCharsUniProc			WinTkGSSubFontDrawCharsUni;

/*  - UTF-8 version */

TkGS_MeasureCharsUtfProc		WinTkGSSubFontMeasureCharsUtf;
TkGS_TextWidthUtfProc			WinTkGSSubFontTextWidthUtf;
TkGS_DrawCharsUtfProc			WinTkGSSubFontDrawCharsUtf;


/*
 * Version-specific internal procs.
 * Some systems (NT) support native Unicode calls, some don't (9x).
 */

typedef HFONT (WinTkGSGetScreenFontProc) _ANSI_ARGS_((HDC hdc,
			    CONST TkGS_FontAttributes *faPtr,
			    CONST char *faceName));
extern WinTkGSGetScreenFontProc *WinTkGSGetScreenFont, 
			    WinTkGSGetScreenFontUni,
			    WinTkGSGetScreenFontSys;

typedef void (WinTkGSGetFaceNameProc) _ANSI_ARGS_((HDC hdc, char *namePtr));
extern WinTkGSGetFaceNameProc *WinTkGSGetFaceName, 
			    WinTkGSGetFaceNameUni,
			    WinTkGSGetFaceNameSys;


extern WinFont * WinTkGS_GetWinFontFromFont _ANSI_ARGS_((Tcl_Interp *interp,
			    TkGS_Drawable d, TkGS_Font font));


extern void WinTkGSInitFontPackage _ANSI_ARGS_(());


/*
 * end of tkgsWinInt.h
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKGSWININT */

