#ifndef _TKGSXLIBFONT
#define _TKGSXLIBFONT

/*
 * Xlib Fonts
 */

/* Constants */
#define XLIB_BASE_CHARS		256

/* Object type */
EXTERN TkGS_ObjType *XlibFontTypePtr;

/* Structures */

typedef struct XlibFontFamily {
    TkGSFontFamily_ header;	/* Must be first */

    Tcl_HashEntry *hashPtr;	/* Pointer to hash table entry that
				 * corresponds to the font family. */

    int isTwoByteFont;		/* 1 if this is a double-byte font, 0 
				 * otherwise. */
} XlibFontFamily;

typedef struct XlibSubFont {
    TkGSSubFont_ header;	/* Must be first */

    XFontStruct *fontStructPtr;	/* The specific screen font that will be
				 * used when displaying/measuring chars
				 * belonging to the XlibFontFamily. */
} XlibSubFont;

typedef struct XlibFont {
    TkGSMultiFont_ header;	/* Must be first */

    TkGS_FontAttributes	fa;	/* Real font attributes (actually, 
				 * for the base font). */
    TkGS_FontMetrics fm;	/* Real font metrics, ditto. */
    /* TODO: widths lazily computed? */
    int widths[XLIB_BASE_CHARS];/* Widths of first 256 chars in the base
				 * font, for handling common case. */
    Display *display;		/* Display that owns font. */
    XFontStruct *fontStructPtr;	/* XFontStruct for base font. */
    XlibSubFont controlSubFont;	/* Font to use to display control-character
				 * expansions. */
} XlibFont;

/* Subfont-related macros */

#define XlibTkGSGetSubFontId(index) \
    ((TkGSSubFontId) (index)+1)
#define XlibTkGSGetControlSubFontId() \
    ((TkGSSubFontId) -1)
#define XlibTkGSGetSubFontIndex(subFontId) \
    ((int) (subFontId)-1)
#define XlibTkGSGetSubFontFromIndex(multiFont, index) \
    (&((XlibSubFont *) ((XlibFont *) (multiFont))->header.subFontArray)[(index)])
#define XlibTkGSGetSubFontFromId(multiFont, subFontId) \
    (  (subFontId) == XlibTkGSGetControlSubFontId() \
     ? (&(((XlibFont *) (multiFont))->controlSubFont)) \
     : (XlibTkGSGetSubFontFromIndex((multiFont), XlibTkGSGetSubFontIndex((subFontId)))))

/* Accessors */
#define XlibFont_InternalRep(intRepPtr) \
    ((XlibFont *) intRepPtr->value.otherValuePtr)

#define XlibFont_MultiFont(intRepPtr) \
    (XlibFont_InternalRep(intRepPtr)->header)
#define XlibFont_FontMetrics(intRepPtr) \
    (XlibFont_InternalRep(intRepPtr)->fm)
#define XlibFont_Widths(intRepPtr) \
    (XlibFont_InternalRep(intRepPtr)->widths)
#define XlibFont_Display(intRepPtr) \
    (XlibFont_InternalRep(intRepPtr)->display)
#define XlibFont_XFontStruct(intRepPtr) \
    (XlibFont_InternalRep(intRepPtr)->fontStructPtr)
#define XlibFont_ControlSubFont(intRepPtr) \
    (&(XlibFont_InternalRep(intRepPtr)->controlSubFont))

#define XlibSubFont_XFontStruct(subFont) \
    (((XlibSubFont *) subFont)->fontStructPtr)

#endif /* _TKGSXLIBFONT */

