#ifndef _TKGSDRAWABLE
#define _TKGSDRAWABLE

/*
 * Drawables
 */

/* Base type */
EXTERN TkGS_BaseType*	TkGS_GetDrawableBaseType();

/* Structure */
typedef struct TkGS_Drawable_ {
    TkGS_Obj    header;		/* Must be first */

    TkGS_Device	device;		/* Device to which the drawable belongs */
    TkGS_GCValues gcValues;	/* Device-independent GC values */
    unsigned long gcValueMask;	/* Mask of altered values since the last
				 * call to one of the GC values accessors
				 * (eg. TkGS_SetGCValues) */
} TkGS_Drawable_;

/* Accessors */
#define TkGSDrawable_Device(objPtr) \
    (((TkGS_Drawable_*)objPtr)->device)
#define TkGSDrawable_GCValues(objPtr) \
    (((TkGS_Drawable_*)objPtr)->gcValues)
#define TkGSDrawable_GCValueMask(objPtr) \
    (((TkGS_Drawable_*)objPtr)->gcValueMask)

/* Functions */
EXTERN TkGS_Drawable_ *	TkGSNewDrawable _ANSI_ARGS_((TkGS_Device device));

#endif /* _TKGSDRAWABLE */

