#include "tkgs.h"
#include "tkgsInt.h"

#include <string.h>

/*
 * Generic TkGS_Obj procedures
 */

TkGS_InternalRep *
TkGS_AddNewInternalRep(interp, objPtr, typePtr)
    Tcl_Interp	 *interp;
    TkGS_Obj	 *objPtr;
    TkGS_ObjType *typePtr;
{
    int nbIntReps = objPtr->baseTypePtr->nbIntReps;
    
    if (objPtr->baseTypePtr != typePtr->baseTypePtr) {
	/* Attempting to convert object with different base types */
	return NULL;
    }

    if (typePtr->setFromAnyProc == NULL) {
	/* Immutable object */
	return NULL;
    }

    /*
     * Add the new internal rep.
     */

    if (nbIntReps == 1) {
	/* Single internal rep */
	if (   typePtr->setFromAnyProc(interp, objPtr, &objPtr->internalRep.single)
	    == TKGS_ERROR) {
	    return NULL;
	}
	return &objPtr->internalRep.single;
    } else {
	/* Multiple internal reps */
	TkGS_InternalRep intRep;
	intRep.typePtr = NULL;
	if (   typePtr->setFromAnyProc(interp, objPtr, &intRep)
	    == TKGS_ERROR) {
	    return NULL;
	}
	return TkGS_PushInternalRep(objPtr, &intRep);
    }
}

TkGS_InternalRep *
TkGS_PushInternalRep(objPtr, intRepPtr)
    TkGS_Obj	     *objPtr;
    TkGS_InternalRep *intRepPtr;
{
    int nbIntReps = objPtr->baseTypePtr->nbIntReps;
    int i;
    register TkGS_InternalRep *oldIntRepPtr;

    if (nbIntReps == 1) {
	/* Single internal rep */
	oldIntRepPtr = &objPtr->internalRep.single;
    } else {
	/* Multiple internal reps */
	if (objPtr->internalRep.multiple == NULL) {
	    /*
	     * No current internal rep. Allocate and initialize storage.
	     */

	    objPtr->internalRep.multiple = (TkGS_InternalRep *) 
		ckalloc(sizeof(TkGS_InternalRep) * nbIntReps);
	    for (i=0; i<nbIntReps; i++) {
		objPtr->internalRep.multiple[i].typePtr = NULL;
	    }
	}
	oldIntRepPtr = objPtr->internalRep.multiple+nbIntReps-1;
    }

    if (   oldIntRepPtr->typePtr != NULL
	&& oldIntRepPtr->typePtr->freeIntRepProc != NULL) {
	oldIntRepPtr->typePtr->freeIntRepProc(intRepPtr);
    }

    if (nbIntReps == 1) {
	/* Single internal rep */
	objPtr->internalRep.single = *intRepPtr;
	return &objPtr->internalRep.single;
    } else {
	/* Multiple internal reps */
	for (i=nbIntReps-1; i>=1; i--) {
	    objPtr->internalRep.multiple[i] = objPtr->internalRep.multiple[i-1];
	}
	objPtr->internalRep.multiple[0] = *intRepPtr;
	return objPtr->internalRep.multiple;
    }
}

TkGS_InternalRep *
TkGS_FindInternalRep(objPtr, typePtr)
    TkGS_Obj *objPtr;
    TkGS_ObjType *typePtr;
{
    int nbIntReps = objPtr->baseTypePtr->nbIntReps;

    if (nbIntReps == 1) {
	/* Single internal rep */
	if (objPtr->internalRep.single.typePtr == typePtr) {
	    return &objPtr->internalRep.single;
	}
    } else {
	/* Multiple internal reps */
	register TkGS_InternalRep *intRepPtr;
	int i;
	if (objPtr->internalRep.multiple) {
	    for (i=0; i<nbIntReps; i++) {
		intRepPtr = objPtr->internalRep.multiple+i;
		if (intRepPtr->typePtr == typePtr) {
		    return intRepPtr;
		}
	    }
	}
    }
    return NULL;
}


TkGS_Obj *
TkGSNewObj(baseTypePtr)
    TkGS_BaseType *baseTypePtr;
{
    register TkGS_Obj *objPtr = (TkGS_Obj *) ckalloc(baseTypePtr->size);

    memset(objPtr, 0, baseTypePtr->size);

    objPtr->baseTypePtr = baseTypePtr;
    objPtr->refCount = 0;

    if (baseTypePtr->nbIntReps == 1) {
	/* Single internal rep */
	objPtr->internalRep.single.typePtr = NULL;
    } else {
	/* Multiple internal reps */
	objPtr->internalRep.multiple = NULL;
    }

    return objPtr;
}

void
TkGSFreeObj(objPtr)
    register TkGS_Obj *objPtr;
{
    int nbIntReps = objPtr->baseTypePtr->nbIntReps;
    register TkGS_InternalRep *intRepPtr;

#ifdef TKGS_MEM_DEBUG
    if ((objPtr)->refCount < -1) {
	panic("Reference count for %lx was negative", objPtr);
    }
#endif /* TKGS_MEM_DEBUG */

    /* Free internal rep(s) */
    if (nbIntReps == 1) {
	/* Single internal rep */
	intRepPtr = &objPtr->internalRep.single;
	if (   intRepPtr->typePtr != NULL
	    && intRepPtr->typePtr->freeIntRepProc != NULL) {
	    intRepPtr->typePtr->freeIntRepProc(intRepPtr);
	}
    } else {
	/* Multiple internal reps */
	if (objPtr->internalRep.multiple) {
	    int i;
	    for (i=0; i<nbIntReps; i++) {
		intRepPtr = objPtr->internalRep.multiple+i;
		if (   intRepPtr->typePtr != NULL
		    && intRepPtr->typePtr->freeIntRepProc != NULL) {
		    intRepPtr->typePtr->freeIntRepProc(intRepPtr);
		}
	    }
	}
    }

    /* Free base rep */
    if (objPtr->baseTypePtr->freeBaseProc) {
	objPtr->baseTypePtr->freeBaseProc(objPtr);
    }

    ckfree((char *) objPtr);
}

TkGS_Obj *
TkGS_DuplicateObj(objPtr)
    register TkGS_Obj *objPtr;		/* The object to duplicate. */
{
    register TkGS_BaseType *baseTypePtr = objPtr->baseTypePtr;
    register TkGS_Obj *dupPtr;

    if (baseTypePtr->dupBaseProc == NULL) {
	return NULL;
    }

    dupPtr = TkGSNewObj(objPtr->baseTypePtr);

    /* Duplicate base rep */
    baseTypePtr->dupBaseProc(objPtr, dupPtr);

    /* We don't duplicate the internal reps */

    return dupPtr;
}


