/*
 * pkg.h --
 *
 *	This file defines the header info for all of the Vu widgets.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: pkg.h,v 1.6 2000/09/28 23:24:35 hobbs Exp $
 */

#ifndef _VU_H_
#define _VU_H_

#include <tk.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>

/*
 * Vu widget default characteristics
 */
#include "pkgDefault.h"

#ifdef MAC_TCL
#   include <Xatom.h>
#else
#   include <X11/Xatom.h>
#endif /* MAC_TCL */

#ifdef BUILD_vu
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#endif

#ifdef _WIN32
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN
/* VC++ has an entry point called DllMain instead of DllEntryPoint */
#   if defined(_MSC_VER)
#	define DllEntryPoint DllMain
#   endif
#endif

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif

#ifndef M_PI
#define M_PI	3.14159265358979323846
#endif /* M_PI */

#ifndef M_PI_2
#define M_PI_2	1.57079632679489661923
#endif

#undef MIN
#define MIN(a, b)	(((a)<(b))?(a):(b))
#undef MAX
#define MAX(a, b)	(((a)>(b))?(a):(b))
#undef ABS
#define ABS(x)		(((x)<0)?(-(x)):(x))
#undef FABS
#define FABS(x) 	(((x)<0.0)?(-(x)):(x))
#undef ROUND
#define ROUND(x)	((int)((x)+(((x)<0.0)?-0.5:0.5)))
#undef EXP10
#define EXP10(x)	(pow(10.0,(x)))

/* Prototypes for each of the widgets. */
EXTERN int	Tk_DialObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
EXTERN int	Tk_PieObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
EXTERN int	Tk_SpinboxObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
EXTERN int	Tk_PanedWindowObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
#if 0
EXTERN int	Tk_BargraphCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int argc, char **argv));
EXTERN int	Tk_ComboboxObjCmd _ANSI_ARGS_((ClientData clientData,
			Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]));
#endif

EXTERN int	Vu_Init _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN int	Vu_SafeInit _ANSI_ARGS_((Tcl_Interp *interp));

/*
 * end of header
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _VU_H_ */
