<xsl:stylesheet version="1.1"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:import href="../../docbook/xsl/html/docbook.xsl"/>

  <xsl:output indent='yes'/>

  <xsl:variable name="html.stylesheet" select="'style/main.css'"/>

  <xsl:template name="body.attributes">
    <xsl:attribute name="bgcolor">#aaaaaa</xsl:attribute>
    <xsl:attribute name="text">black</xsl:attribute>
    <xsl:attribute name="link">#0000cc</xsl:attribute>
    <xsl:attribute name="vlink">#840084</xsl:attribute>
    <xsl:attribute name="alink">#0000ff</xsl:attribute>
  </xsl:template>

  <xsl:template match="book">
    <xsl:call-template name="main"/>
  </xsl:template>
  <xsl:template match="*" mode="main">
    <!-- Following results in infinite loop -->
    <!-- <xsl:apply-templates select='.' mode='process.root'/> -->

    <xsl:variable name='doc' select='self::*'/>

    <html>
      <head>
        <xsl:call-template name="head.content">
          <xsl:with-param name="node" select="$doc"/>
        </xsl:call-template>
        <xsl:call-template name="user.head.content">
          <xsl:with-param name="node" select="$doc"/>
        </xsl:call-template>
      </head>
      <body>
        <xsl:call-template name="body.attributes"/>
        <xsl:call-template name="user.header.content">
          <xsl:with-param name="node" select="$doc"/>
        </xsl:call-template>
        <xsl:call-template name="main"/>
        <xsl:call-template name="user.footer.content">
          <xsl:with-param name="node" select="$doc"/>
        </xsl:call-template>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="chapter">
    <xsl:message>Processing chapter <xsl:value-of select='title|chapterinfo/title'/></xsl:message>
    <xsl:document href='{substring-before(@fileref, ".xml")}.html'>
      <xsl:apply-templates select='.' mode='main'/>
    </xsl:document>
    <div class='chaptertocentry'>
      <a href='{substring-before(@fileref, ".xml")}.html'>
        <xsl:value-of select='title|chapterinfo/title'/>
      </a>
      <xsl:if test='subtitle|chapterinfo/subtitle'>
        <xsl:text> - </xsl:text>
        <xsl:value-of select='subtitle|chapterinfo/subtitle'/>
      </xsl:if>
    </div>
  </xsl:template>

  <xsl:template name='appendix.titlepage'>
    <div class='titlepage'>
      <h2 class='title'>
        <xsl:value-of select='title|appendixinfo/title'/>
      </h2>
    </div>
  </xsl:template>

  <xsl:template name="main">
    <xsl:variable name='current' select='.'/>

    <table width='100%' border='0' cellspacing='0' cellpadding='0' class='heading'>
      <tr>
        <td valign='top' align='left'>
          <div class='{name()}highlights'>
            <xsl:apply-templates select="*[self::bookinfo|self::chapterinfo]/highlights"/>
          </div>
        </td>
        <td valign='top' align='center' width='80%'>
          <div class='{name()}title'>
            <xsl:value-of select='title|bookinfo/title|chapterinfo/title'/>
          </div>
          <xsl:if test='subtitle|bookinfo/subtitle|chapterinfo/subtitle'>
            <div class='{name()}subtitle'>
              <xsl:value-of select='subtitle|bookinfo/subtitle|chapterinfo/subtitle'/>
            </div>
          </xsl:if>
        </td>
      </tr>
    </table>

    <table width="100%" border="0" cellspacing="0" cellpadding="0" class='main'>
      <tr>
        <td valign='top' width='20%' class='index'>
          <a href='index.html'>
            <span class='index-home'>
              <xsl:text>Project Home</xsl:text>
            </span>
          </a>
          <xsl:if test='count(ancestor::*) = 0'>
            <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
            <img src='images/pointer.gif' alt='You are here' title='You are here' border='0'/>
          </xsl:if>
          <br/>
          <xsl:for-each select='//chapter'>
            <a href='{substring-before(@fileref, ".xml")}.html'>
              <xsl:choose>
                <xsl:when test='. = $current and section'>
                  <img src='images/open.gif' alt='' border='0'/>
                </xsl:when>
                <xsl:otherwise>
                  <img src='images/closed.gif' alt='Open this chapter' title='Open this chapter' border='0'/>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
              <span class='index-chapter'>
                <xsl:value-of select='title|chapterinfo/title'/>
              </span>
            </a>
            <xsl:if test='. = $current and section'>
              <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
              <img src='images/pointer.gif' alt='You are here' title='You are here' border='0'/>
            </xsl:if>
            <br/>
            <xsl:if test='. = $current and section'>
              <xsl:for-each select='section'>
                <xsl:variable name='id'>
                  <xsl:call-template name='object.id'>
                    <xsl:with-param name='object' select='.'/>
                  </xsl:call-template>
                </xsl:variable>
                <xsl:text disable-output-escaping='yes'>&amp;nbsp;&amp;nbsp;</xsl:text>
                <a href='#{$id}'>
                  <img src='images/closed.gif' alt='Go to this section' title='Go to this section' border='0'/>
                  <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
                  <span class='index-section'>
                    <xsl:value-of select='title|sectioninfo/title'/>
                  </span>
                </a>
                <br/>
              </xsl:for-each>
            </xsl:if>
          </xsl:for-each>
        </td>

        <td width='10' class='separator'>
          <xsl:text disable-output-escaping='yes'>&amp;nbsp;</xsl:text>
        </td>

        <td valign='top'>
          <xsl:apply-templates select="*[not(self::bookinfo|self::chapterinfo)]"/>
        </td>
      </tr>
    </table>

  </xsl:template>

  <!-- Override is.acceptable.mediaobject because it tries to be
       too clever -->

  <xsl:template name='is.acceptable.mediaobject'>
    <xsl:text>1</xsl:text>
  </xsl:template>

  <!-- We need to handle SVGs differently -->

  <xsl:template match="imagedata">
    <xsl:choose>
      <xsl:when test="contains(@fileref, '.svg')">
        <embed src='{@fileref}' width='500' height='400'/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-imports/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>

