#                     #
# header/mailtool.tcl #
#######################

#############################################################################
#                                                                           #
# This file contains procedures to parse a SUN mailtool message.            #
#                                                                           #
#############################################################################


#
# If multipart add boundary as search string
proc check_mailtool_multipart {} {
		addboundary "----------"
}

#
# If file, get the filename
proc check_mailtool_file {} {
	set NAME [getheader "X-Sun-Data-Name"]
	if {[is_set NAME]} {
		setfilename "$NAME"
	}
}

#
# If text, grab the charset
proc check_mailtool_text {} {
	set CHARSET [getheader "X-Sun-Charset"]
	if {[is_set $CHARSET]} {
		setfromcharset $CHARSET
	}
}


#
# Main routine for parsing SUN MailTool type headers
#

proc check_mailtool_header { } {
	global MAINTYPE
	global KNOW_TYPE

	#
	# If type specifically known not to be SUN MailTool return.
	# MIME messages are checked for first so if we pass the MAINTYPE
	# test it's sure not a MIME message.
	#
	if {[is_set MAINTYPE]} {
		if {$MAINTYPE != "MAILTOOL"} {
			return 0
		}
	} \
	else \
	{
		#
		# If processing root of message then check if message
		# has got the required headers. If so, this
		# message is considered to be in MailTool format, else return
		# and check other message types.
		#
		if {[set CONTENTTYPE [getheader "Content-Type"]] != 0} {
			set MAINTYPE "MAILTOOL"
			setmaintype "MAILTOOL"
		} \
		else \
		{
			return 0
		}
	}

	addspecheader Content-Length
	if {[is_set CONTENTTYPE]} {

		addspecheader Content-Type
	
		set CTYPE [string tolower $CONTENTTYPE]
		case $CTYPE in { 
	
		text 	{
				settype "TEXT"
				check_mailtool_text
			}
	
		x-sun-attachment	{
				settype "MULTIPART"
				check_mailtool_multipart
			}
		}
	} \
	else \
	{
	# This is one of the subparts of this message
	set LINES [getheader "X-Sun-Content-Lines"]
	if {[is_set LINES]} {
		setpartlen $LINES
	}

	set DATATYPE [getheader "X-Sun-Data-Type"]
	set DTYPE [string tolower $DATATYPE]
	case $DTYPE in {

		text	{
				settype "TEXT"
			}

		default-app	{
				settype "APPLICATION"
				check_mailtool_file
			}	
	
		gif-file	{
				settype "IMAGE"
				setsubtype "GIF"
				check_mailtool_file
			}

		audio-file	{
				settype "AUDIO"
				setsubtype "ULAW"
				check_mailtool_file
			}

		default	{
				settype "TEXT"
				check_mailtool_file
			}
		


		}
	}
	addspecheader X-Sun-Charset
	addspecheader X-Sun-Data-Name
	addspecheader X-Sun-Encoding-Info
	addspecheader X-Sun-Data-Type
	addspecheader X-Sun-Data-Description
	addspecheader X-Sun-Content-Lines
	addspecheader X-Sun-Content-Length
}

check_mailtool_header



