.TH EMIL 1 "26 November 1993"
.SH NAME
emil \- convert enclosure and character set of an Internet message
.SH SYNOPSIS
.B emil
.RB  "[\ " "-i"  
.IR  "Infile" "\ ]"
.RB  "[\ " "-o"
.IR  "Outfile" "\ ]"
.RB  "[\ " "-c"
.IR  "Input_Charset" "\ ]"
.I "Conversion_Script"
.SH DESCRIPTION
The message conversion filter
.BR  emil
is used to convert the encoding of enclosures and character set of an Internet 
message. The target format
.IR Conversion_Script 
is a script written in
.BR TCL
that specifies what conversions to make. 

The conversion scripts 
are
available under the directory
EMILCONV
and all have the extension 
.BR  ".tcl" "."
.SH OPTIONS
.LP
Options may appear in any order, but they all must appear before the
.IR Conversion_Script .
.RS
.TP 
.BI "\-i " Infile
Input file. If not specified standard input is used.
.TP 
.BI "\-o " Outfile
Output file. If not specified standard output is used.
.TP
.BI "\-c " Input_Charset
Input character set. This is used as default when no 
character set is specified in the headers of the incoming 
message.
.SH EXAMPLES
.LP
To convert a MIME message in file
.B mime_file
to Open Windows mailtool format, and produce the result on 
standard output:
.TP
.RS .5i
.B "example% emil -i mime_file mailtool"
.LP
.RS -.5i
To convert a straight rfc822 format message with text in CP437
from standard input
to a MIME format message on standard output:
.TP
.RS .5i
.B "example% cat rfc822.file | emil -c CP437 mime"
.SH FILES
.PD 0
.TP 20
EMILDIR
directory containing all 
.B TCL
scripts.
.TP
EMILHEADER
script run when investigating a body part
.TP
EMILRUN
script run to source some 
.B TCL
help files
.TP
EMILCONV
directory containing the conversion scripts
.TP
EMILHDRS
directory containing the investigation scripts
.TP
EMILCHK
directory containing common support scripts
.TP
CHARCPL
file containing the character set conversion tables
.TP
EMILLOG
log file used by
.I Emil
.SH AUTHOR
Martin Wendel (Martin.Wendel@udac.uu.se)
.SH "SEE ALSO"
The Emil manual.
.SH BUGS
Character set conversion from the character sets DK-US and US-DK
is not available and should be checked for.




