/*
**
** Copyright (C) 1994 Swedish University Network (SUNET)
**
**
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**
**                                        Martin.Wendel@udac.uu.se
**                                        Torbjorn.Wictorin@udac.uu.se
**
**                                        UDAC	
**                                        P.O. Box 174
**                                        S-751 04 Uppsala
**                                        Sweden
**
*/


#include "emil.h"

void	encode_rfc822(struct message *m)
{
  return;
}

int	decode_rfc822(struct message *m)
{
  char *c;
  if (m->level == 0)
    {
      m->sd->format = RFC822;
      m->sd->encoding = E7BIT;

      m->sd->check = E7BIT | EUUENCODE | EBINHEX;
      /* Look for IDA sendmail m->charset specification */
      if ((c =  (char *)gethval(m, "X-charset", 0)) != NULL)
	m->sd->charset = c;
      else
	m->sd->charset = (char *)source->charset;
    }
  return(OK);
}

void multipart_kludge(struct message *m)
{
  if (m->child != NULL)
    multipart_kludge(m->child);
  if (m->sibling != NULL)
    multipart_kludge(m->sibling);
  if (m->children == 1 && m->child->td->encoding != EMULTI)
    /* Single Part typed multipart */
    {
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "*** MULTIPART_KLUDGE collapsing at level %d\n",
		m->level);
#endif
      m->td = m->child->td;
      m->sd->type = m->child->sd->type;
      m->child = NULL;
    }
}
