#include "emil.h"
int
fix_applefile(struct message *m)
{
  struct message *mt;
#ifdef DEBUG
  if (edebug)
    fprintf(stderr, "*  fix_applefile: ");
#endif
  if (check_apple_target(m->sd) == OK)
    {
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "keeping.\n");
#endif
      return(NOK);
    }
#ifdef DEBUG
  if (edebug)
    fprintf(stderr, "processing... ");
#endif

  if (to_applefile(m) != OK)
    {
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "FAILED.\n");
#endif
      m->sd->applefile = 0;
      return(NOK);
    }
  switch(target->iapple)
    {
    case ABINHEX:
      if (encode_binhex(m) != OK)
	return(NOK);
      break;
    case ASINGLE:
      if (put_applesingle(m) != OK)
	return(NOK);
      break;
    case ADOUBLE:
      if (put_appledouble(m) != OK)
	return(NOK);
      mt = (struct message *)Yalloc(sizeof(struct message));
      mt->sd = m->sd;
      mt->td = m->td;
      mt->sdl = m->sdl;
      mt->tdl = m->tdl;
      mt->level = m->level + 1;
      
      m->sd = (struct data *)Yalloc(sizeof(struct data));
      m->sd->encoding = EMULTI;
      m->td = m->sd;
      m->child = mt;
      mt->parent = m;
      m->child = (struct message *)split_data_list(m->child);
      m->child->sibling->sd->type = m->child->sd->type;
      m->child->sibling->sd->name = m->child->sd->name;
      m->child->sd->name = (char *)Yalloc(strlen(m->child->sd->name) + 2);
      sprintf(m->child->sd->name, "%%%s", m->child->sibling->sd->name);
      m->sd->type = NEWSTR("MULTIPART");
      m->sd->applefile = AMDOUBLE;
      m->child->sd->type = NEWSTR("APPLESINGLE");
      break;
    default:
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "FAILED.\n");
#endif
      return(NOK);
      break;
    }
#ifdef DEBUG
  if (edebug)
    fprintf(stderr, "SUCCEEDED.\n");
#endif
  return(OK);
}

int
to_applefile(struct message *m)
{
  struct data *d;
  switch(m->sd->applefile)
    {
    case ABINHEX:
      if (decode_binhex(m) == OK)
	return(OK);
      else
	return(NOK);
      break;
    case AMDOUBLE:
      if (decode_double(m->child) != OK)
	return(NOK);
      if (get_appledouble_binary(m->child) != OK)
	return(NOK);
      m->td = m->child->sibling->td;
      m->td->next = m->child->td;
      m->sd->applefile = AFILE;
      m->sd->appletype = m->child->sd->appletype;
      m->sd->name = m->child->sd->name;
      m->td->next->applefile = ARESOURCE;
      m->child = NULL;
      return(OK);
      break;
    case ADOUBLE:
      if (decode_double(m) != OK)
	return(NOK);
      if (get_appledouble_binary(m) != OK)
	return(NOK);
      d = m->td;
      m->td = m->sibling->td;
      m->td->next = d;
      m->td->applefile = AFILE;
      m->td->next->applefile = ARESOURCE;
      m->sibling = m->sibling->sibling;
      return(OK);
      break;
    case ASINGLE:
      if (decode_enc(m) != OK)
	return(NOK);
      if (get_applesingle_binary(m) != OK)
	return(NOK);
      else
	return(OK);
      break;
    case AFILE:
      return(OK);
      break;
    case AMFILE:
      m->td = m->child->sibling->td;
      m->td->next = m->child->td;
      m->td->applefile = AFILE;
      m->td->next->applefile = ARESOURCE;
      m->child = NULL;
      return(OK);
      break;
    default:
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "UNKNOWN applefile type.\n");
#endif
      return(NOK);
      break;
    }
  return(NOK);
}

int
decode_double(struct message *m)
{
#ifdef DEBUG
  if (edebug)
    fprintf(stderr, "*   decode_double\n");
#endif
  if (m->sibling == NULL)

    return(NOK);

  if (decode_enc(m) != OK)
    return(NOK);
  if (decode_enc(m->sibling) != OK)
    return(NOK);
  return(OK);
}

int
decode_enc(struct message *m)
{
  m->td->offset = m->td->bodystart;
  switch(m->td->encoding)
    {
    case EUUENCODE:
      return(decode_uuencode(m));
      break;
    case EBASE64:
      return(decode_base64(m));
      break;
    case EBINHEX:
      return(decode_binhex(m));
      break;
    case EQP:
      return(decode_quoted_printable(m));
      break;
    default:
      return(NOK);
    }
}

