#include "emil.h"
extern long memall;

void
safe_mchange(struct message *m, struct data *d)
{
#ifdef DEBUG
  if (edebug)
    fprintf(stderr, "*  safe_mchange: ");
#endif
  if (m == NULL || d == NULL)
    {
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "Null input, ignoring...\n");
#endif
      return;
    }
  m->td->type = m->sd->type;
  m->td->name = m->sd->name;
  m->td->nameext = m->sd->nameext;
  if (d->appletype != NULL)
    bcopy(d->appletype, m->td->appletype, 9);
  m->td->description = m->sd->description;
  if (m->td == d)
    {
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "Pointers identical, ignoring...\n");
#endif
      return;
    }
  if ((memcmp(m->td->contents + m->td->bodystart, 
	     d->contents,
	     m->td->bodyend - m->td->bodystart) == 0))
    {
      if (d->charset != NULL)
	m->td->charset = NEWSTR(d->charset);
      m->td->encoding = d->encoding;
#ifdef DEBUG
      if (edebug)
	fprintf(stderr, "Data identical, ignoring...\n");
#endif
      (void)free_data(d);
      return;
    }
  if (m->td != m->sd)
    {
      (void)free_data(m->td);
    }
#ifdef DEBUG
  if (edebug)
    fprintf(stderr, "Data has been exchanged. Old size was %lu, new size is %lu\n",
	    m->td->bodyend - m->td->bodystart,
	    d->bodyend - d->bodystart);
#endif
  m->td = d;
  return;
}

void
free_data(struct data *d)
{
  /* Get rid of contents, leave the rest */
  if (d == NULL)
    return;
#ifdef DEBUG
  alloc_total -= d->size;
  if (edebug)
    {
      fprintf(stderr, "* Freed %lu, new total %lu\n", d->size, alloc_total);
      fflush(stderr);
    }
#endif
  if (d->contents != NULL)
    free(d->contents);
  memall -= d->size;
}
