#include "emil.h"
struct mparts {
  char *part;
  struct mparts *next;
};

main(int argc,char ** argv)
{
  struct mparts *mp, *tmp, *arglist, *alist, *llist, *lalist;
  char *path;
  FILE *sendmailcf;
  char *localmailer;
  char *mpath;
  char tempc[1024];
  int found = 0;
  int unixfrom = 0;
  int sender, recip, xhost;
  sender = recip = xhost = 0;
  
  if (argc != 2)
    {
      fprintf(stderr, "USAGE: %s <path_of_sendmail.cf>\n", argv[0]);
      exit(FAIL);
    }
  path = argv[1];
  if ((sendmailcf = fopen(path, "r")) == NULL)
    {
      fprintf(stderr, "ERROR: %s unable to open %s\n", argv[0], argv[1]);
      exit(FAIL);
    }
  localmailer = (char *)malloc(2048);
  /* Get local mailer line */
  while (fgets(localmailer, 2048, sendmailcf) != NULL)
    {
      if (localmailer[0] == 'M' && strncasecmp(localmailer, "mlocal", 6) == 0)
	{
	  found = 1;
	  if (fgets(tempc, 1024, sendmailcf) != NULL)
	    {
	      if (tempc[0] == ' ' || tempc[0] == '\t')
		strcpy(&localmailer[strlen(localmailer)], tempc);
	    }
	  break;
	}
    }
  if (found == 0)
    {
      fprintf(stderr, "ERROR: %s unable to find local mailer definition in %s\n",
	      argv[0], argv[1]);
      exit (FAIL);
    }
  else
    {
      printf("\n\n");
      printf("This program will help you to set up Emil as a filter to the\n");
      printf("local mailer of sendmail.\n\n");
      printf("Locate the following line in %s:\n\n", argv[1]);
      printf("\t%s\n", localmailer);
      printf("Modify it to look like this:\n\n");
    }
  /* Take it apart */
  mp = (struct mparts *)calloc(sizeof(struct mparts), 1);
  mp->part = localmailer;
  tmp = mp;
  while ((localmailer = index(localmailer, ',')) != NULL)
    {
      *localmailer = '\0';
      localmailer++;
      while(isspace(*localmailer))
	{
	  *localmailer = '\0';
	  localmailer++;
	}
      tmp->next = (struct mparts *)calloc(sizeof(struct mparts), 1);
      tmp = tmp->next;
      tmp->part = localmailer;
    }
  /* Change the parts we want */
  for (tmp = mp; tmp != NULL; tmp = tmp->next)
    {
      char *tt, *tmt;
      char flag;
      if (*(tmp->part) == 'F' || *(tmp->part) == 'f')
	{
	  if ((tt = index(tmp->part, '=')) == NULL)
	      {
		fprintf(stderr, 
			"ERROR: %s unable to resolve format of the localmailer\n", argv[0]);
		exit(FAIL);
	      }
	  tt++;
	  while (isspace(*tt))
	    tt++;
	  if (index(tt, 'n') != NULL)
	    unixfrom = 1;
	}

      if (*(tmp->part) == 'P' || *(tmp->part) == 'p')
	{
	  flag = *(tmp->part);
	  if ((tt = index(tmp->part, '=')) == NULL)
	      {
		fprintf(stderr, 
			"ERROR: %s unable to resolve format of the localmailer\n", argv[0]);
		exit(FAIL);
	      }
	  tt++;
	  while (isspace(*tt))
	    tt++;
	  mpath = NEWSTR(tt);
	  sprintf(tempc, "%c=%s", flag, EMILPATH);
	  tmp->part = NEWSTR(tempc);
	}
      if ( *(tmp->part) == 'A' ||  *(tmp->part) == 'a')
	{
	  flag = *(tmp->part);
	  if ((tt = index(tmp->part, '=')) == NULL)
	      {
		fprintf(stderr, 
			"ERROR: %s unable to resolve format of the localmailer\n", argv[0]);
		exit(FAIL);
	      }
	  tt++;
	  while (isspace(*tt))
	    tt++;
	  tmt = tt;
	  sprintf(tempc, "%c=emil", flag);
	  while (isspace(*tt) == 0)
	    tt++;
	  *tt = '\0';
	  tt++;
	  arglist = (struct mparts *)calloc(sizeof(struct mparts), 1);
	  llist = (struct mparts *)calloc(sizeof(struct mparts), 1);
	  arglist->part = llist->part = tmt;
	  alist = arglist;
	  lalist = llist;
	  while (*tt != '\0')
	    {
	      while (isspace(*tt))
		tt++;
	      alist->next = (struct mparts *)calloc(sizeof(struct mparts), 1);
	      alist = alist->next;
	      alist->part = tt;
	      while (isspace(*tt) == 0)
		tt++;
	      *tt = '\0';
	      tt++;
	    }
	  for (alist = arglist->next; alist != NULL; alist = alist->next)
	    {
	      lalist->next = (struct mparts *)calloc(sizeof(struct mparts), 1);
	      lalist = lalist->next;
	      if (*(alist->part) == '$')
		switch (*(alist->part + 1))
		  {
		  case 'f':
		  case 'g':
		    lalist->part = NEWSTR("$s");
		    sprintf(tempc, "%s -s %s", tempc, alist->part);
		    sender = 1;
		    break;
		  case 'u':
		    lalist->part = NEWSTR("$r");
		    sprintf(tempc, "%s -r %s", tempc, alist->part);
		    recip = 1;
		    break;
		  default:
		    fprintf(stderr, "ERROR: %s cannot handle this mailer specification.\n", argv[0]);
		    fprintf(stderr, "Try the documentation instead.\n");
		    exit(FAIL);
		    break;
		  }
	      else
		lalist->part = alist->part;

	    }
	  if (sender == 0)
	    sprintf(tempc, "%s -s $g -m local", tempc);
	  else
	    sprintf(tempc, "%s -m local", tempc);
	  if (unixfrom)
	    sprintf(tempc, "%s -u", tempc);
	  tmp->part = NEWSTR(tempc);
	}
    }
  printf("\t%s", mp->part);
  for (tmp = mp->next; tmp != NULL; tmp = tmp->next)
    {
      printf(", %s", tmp->part);
    }
  printf("\n\n");
/*
  printf("%s", arglist->part);
  for (tmp = arglist->next; tmp != NULL; tmp = tmp->next)
    {
      printf(", %s", tmp->part);
    }
  printf("\n");
*/
  printf("Also, add the following line to your %s:\n\n", MAINCF);
  printf("\tmailer local : %s, %s", mpath, llist->part);
  for (tmp = llist->next; tmp != NULL; tmp = tmp->next)
    {
      printf(", %s", tmp->part);
    }
  printf("\n\n");
  printf("Restart sendmail and try it out.\n");
}
  
