#include "emil.h"

char *
makelong(unsigned long i, int length)
{
  unsigned char *s, *t;
  s = (char *)Yalloc(length + 1);
  t = s;
  for (;length != 0; length--)
    {
      *s = 0xFF & (i >> (length - 1)*8);
      s++;
    }
  return(t);
}


int
getlong(unsigned long *l, struct data *d)
{
  unsigned char *s;
  int i;
  if (get_length(d) < 4)
    return(NOK);
  s = d->contents + d->offset;
  *l = 0;
  for (i = 0; i < 4; i++)
      *l = (unsigned long) *s++ | *l<<8;
  d->offset += 4;
  return(OK);
}

unsigned long
getblong(unsigned char *s)
{
  unsigned long l;
  int i;
  l = 0;
  for (i = 0; i < 4; i++)
      l = (unsigned long) *s++ | l<<8;
  return(l);
}

int
getshort(unsigned short *l, struct data *d)
{
  unsigned char *s;
  int i;
  if (get_length(d) < 2)
    return(NOK);
  s = d->contents + d->offset;
  *l = 0;
  for (i = 0; i < 2; i++)
      *l = (unsigned short) *s++ | *l<<8;
  d->offset += 2;
  return(OK);
}

