#
# check/check.tcl
#
# Set type&creator for binhex
#
proc set_binhex {} {
	
	if {[set SUBTYPE [getsubtype]] != 0} {
		case $SUBTYPE in {
			MS-WORD	{
					setbinhextype "WDBN"
					setbinhexauth "MSWD"
				}
			MAC-WRITE	{
					setbinhextype "WORD"
					setbinhexauth "MACA"
					}
			EXCEL	{
					setbinhextype "XLS "
					setbinhexauth "XCEL"
				}
			GIF	{
					setbinhextype "GIFf"
					setbinhexauth "JVWR"
				}
			JPEG	{
					setbinhextype "JPEG"
					setbinhexauth "JVWR"
				}
			default {
				setbinhextype "TEXT"
				setbinhexauth "ttxt"
				}
		}
	} \
	else \
	{
		# Default
		setbinhextype "TEXT"
		setbinhexauth "ttxt"
	}
}



proc set_uuencode {} {
	if {[set SUBTYPE [getsubtype]] != 0} {
		case $SUBTYPE in {
			MS-WORD	{setextension "DOC"}
			EXCEL	{setextension "XLS"}
			MAC-WRITE	{setextension "TXT"}
			GIF		{setextension "GIF"}
			JPEG		{setextension "JPG"}
			default		{setextension $SUBTYPE}
		}
	}
}



proc do_decode {} {

	set ENC [getencoding]

	if {$ENC == "UUENCODE"} {
		decode "UUENCODE"
	}
	if {$ENC == "BINHEX"} {
		decode "BinHex"
	}
	if {$ENC == "BASE64"} {
		decode "Base64"
	}
	if {$ENC == "QUOTED-PRINTABLE"} {
		decode "Quoted-Printable"
	}

}

proc do_code {TOENC} {

	set ENC [getencoding]
	
	if {$TOENC == $ENC} {
		return 0
	}
	case $ENC in {	
	UUENCODE	{
				decode "UUENCODE"
			}
	BINHEX		{
				decode "BinHex"
			}
	BASE64		{
				decode "Base64"
			}
	QUOTED-PRINTABLE	{
				decode "Quoted-Printable"
			}
	default		{
				return 0
			}
	}
	if {$TOENC == "BINHEX"} {
		set_binhex
	} \
	else \
	{
		set_uuencode
	}
	encode $TOENC
}
	
