#
# check/settype.tcl
#
# Default template for check of BinHex and uuencode file types


#
# Set type of binhexed message part
#

proc check_binhex {} {

	if {[getencoding] != "BINHEX"} {
		return 0
	}
	if {[gettype] == "BINHEX"} {
		return 0
	}

	# Default
	set MAC_TYPE [getbinhextype]
	set MAC_AUTH [getbinhexauth]
	settype "APPLICATION"
	setsubtype $MAC_TYPE
	debug "Grabbing MAC TYPE $MAC_TYPE"
	debug "Grabbing MAC AUTH $MAC_AUTH"

	case $MAC_AUTH in {

	MSWD	{
			settype "APPLICATION"
			setsubtype "MS-WORD"
		}

	MACA	{
			settype "APPLICATION"
			setsubtype "MAC-WRITE"
		}

	XCEL	{
			settype "APPLICATION"
			setsubtype "EXCEL"
		}
	}

# Generic formats
	case $MAC_TYPE in {
	GIFf	{
			settype "IMAGE"
			setsubtype "GIF"
		}

	JFIF	{
			settype "IMAGE"
			setsubtype "JPEG"
		}

	JPEG	{
			settype "IMAGE"
			setsubtype "JPEG"
		}
	}
}


#
#

proc check_uuencode {} {
	if {[getencoding] != "UUENCODE"} {
		return 0
	}
	if {[gettype] != "TEXT"} {
		return 0
	}
	# Default
	settype "APPLICATION"
	if {[set FILENAME [getfilename]] != 0} {
		if {[set EXT [getextension $FILENAME]] != 0} {
			# Use Upper chars only
			set EXTU [string toupper $EXT]
			case $EXTU in {
			DOC	{
					settype "APPLICATION"
					setsubtype "MS-WORD"
				}

			XLS	{
					settype "APPLICATION"
					setsubtype "EXCEL"
				}

			TXT	{	
					settype "APPLICATION"
					setsubtype "MAC-WRITE"
				}

			GIF	{
					settype "IMAGE"
					setsubtype "GIF"
				}

			JPG	{
					settype "IMAGE"
					setsubtype "JPEG"
				}

			JPEG	{
					settype "IMAGE"
					setsubtype "JPEG"
				}
			}
		}
	}
}




set ENCODING [getencoding]

case $ENCODING in {

BINHEX 		{
			check_binhex
		}

UUENCODE	{
			check_uuencode
		}

default		{
			settype "UNKNOWN"
		}

}



