/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */






#include "mk.h"
BufStruct *mkbufalloc();
MessageStruct *mkmessalloc();

int
mkaddmessnode()
{
  MessageStruct *mess;
  mess = MkMess_Curr;
  if (mess == NULL)
    return(-1);
  while (mess->next != NULL)
    mess = mess->next;
  if ((mess->next = (MessageStruct *)mkmessalloc()) == NULL) {
#ifdef EMILDEBUG
    Mk_Log(LOG_ERR, "mkaddmessnode: mkmessalloc allocation failure");
#endif
    return(-1);
  }
#ifdef EMILDEBUG
  Mk_Log(LOG_DEBUG, "Adding new message node");
#endif
  MkMess_Curr = mess->next;
  MkMess_Buf = MkMess_Curr->buf;
  if (mess == MkMess_Root)
    copymessnode();
  else {
    MkMess_Root->ismulti = TRUE;
    Mk_Log(LOG_DEBUG, "addmessnode: Setting multipart");
  }
  return(0);
}

int
copymessnode()
{
  if (MkMess_Root->maintype)
    MkMess_Curr->maintype = (char *)newstr(MkMess_Root->maintype);
  if (MkMess_Root->subtype)
    MkMess_Curr->subtype = (char *)newstr(MkMess_Root->subtype);
  if (MkMess_Root->filename) {
    MkMess_Curr->filename = (char *)newstr(MkMess_Root->filename);
    MkMess_Curr->filenamelen = MkMess_Root->filenamelen;
  }
  if (MkMess_Root->encoding)
    MkMess_Curr->encoding = (char *)newstr(MkMess_Root->encoding);
  MkMess_Curr->enc = MkMess_Root->enc;
  MkMess_Curr->type = MkMess_Root->type;
}
  

MessageStruct *
mkmessalloc()
{
  MessageStruct *mess;
  mess = (MessageStruct *)xalloc(sizeof(MessageStruct));
  mess->binhex = (BinHexStruct *)xalloc(sizeof(BinHexStruct));
  mess->buf = (BufStruct *)mkbufalloc();
  return(mess);
}

int
mkaddbufnode()
{
  BufStruct *buf;
  buf = MkMess_Buf;
  if (buf == NULL) {
#ifdef EMILDEBUG
    Mk_Log(LOG_ERR, "mkaddbufnode: NULL input data");
#endif
    return(-1);
  }
  while (buf->next != NULL)
    buf = buf->next;
  if ((buf->next = (BufStruct *)mkbufalloc()) == NULL) {
#ifdef EMILDEBUG
    Mk_Log(LOG_ERR, "mkaddbufnode: mkbufalloc allocation error");
#endif
    return(-1);
  }
  else
    {
      buf->next->in = buf->out;
      MkMess_Buf = buf->next;
#ifdef EMILDEBUG
      Mk_Log(LOG_DEBUG, "Adding new buffer node");
#endif
    }
  return(0);
}


BufStruct *
mkbufalloc()
{
  BufStruct *buf;
  buf = (BufStruct *)xalloc(sizeof(BufStruct));
  buf->out = (char *)xalloc(BUFSIZE);
  buf->inrest = (char *)xalloc(BUFSIZE);
  return(buf);
}

int
mknewallbufs()
{
  MessageStruct *mess;
  for (mess = MkMess_Root; mess != NULL; mess = mess->next)
    {
      if (mess->buf)
	mkfreebuf(mess->buf);
      mess->buf = (BufStruct *)mkbufalloc();
    }
}

int
mkfreebuf(buf)
BufStruct *buf;
{
  if (buf) {
    if (buf->next)
      mkfreebuf(buf->next);
    if (buf->out)
      free(buf->out);
    if (buf->inrest)
      free(buf->inrest);
    free(buf);
  }
#ifdef EMILDEBUG
  else
    Mk_Log(LOG_DEBUG, "mkfreebuf: tried to free NULL");
#endif
}

int
mksetlast(mk, val)
     MessageStruct *mk;
     bool val;
{
  mk->last = val;
}

int
mksetfirst(mk, val)
     MessageStruct *mk;
     bool val;
{
  BufStruct *buf;
  mk->first = val;
  if (val)
    for (buf = mk->buf; buf != NULL; buf = buf->next)
      {
	buf->inpartlen = 0;
	buf->outpartlen = 0;
	buf->inrestlen = 0;
	buf->outlen = 0;
      }
}

