/*
**
** Copyright (C) 1994 Swedish University Network (SUNET)
**
**
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**
**                                        Martin.Wendel@udac.uu.se
**                                        Torbjorn.Wictorin@udac.uu.se
**
**                                        UDAC	
**                                        P.O. Box 174
**                                        S-751 04 Uppsala
**                                        Sweden
**
*/


#include "emil.h"

void
macify_filename(struct message *m)
{
  char *name;
  char *appletype;
  if (m->name == NULL)
    return;
  fix_filename(m);
  for (name = m->name; *name != '\0'; name++)
    {
      switch (*name)
	{
	case ':':
	  *name = '-';
	  break;
	default:
	  break;
	}
      if (*name & 0x80)
	*name = '_';
    }
  if (m->appletype[0] == '\0')
    {
      if (m->type == NULL)
	strncpy(m->appletype, "AURL    ", 8);
      else
	{
	  if ((appletype = confextr("APPLEFILE", NULL, m->type)) == NULL)
	    if ((appletype = confextr("APPLEFILE", NULL, "DEFAULT")) == NULL)
	      strncpy(m->appletype, "AURL    ", 8);
	  if (appletype != NULL)
	    strcpy(m->appletype, appletype);
	}
    }
}

void
dosify_filename(struct message *m)
{
  char *name;
  char *extension;
  int i;
  if (m->name == NULL)
    return;
  fix_filename(m);
  extension = (char *)getextension(m->name);
  for (name = m->name, i = 0; *name != '\0'; name++, i++)
    {
      if ((name + 1 == extension) || i == 8)
	  break;
      switch (*name)
	{
	case '\\':
	  *name = '-';
	  break;
	case '.':
	  *name = '-';
	default:
	  break;
	}
      if (*name & 0x80)
	*name = '_';
    }
}

void
unixify_filename(struct message *m)
{
  char *name;
  if (m->name == NULL)
    return;
  fix_filename(m);
  for (name = m->name; *name != '\0'; name++)
    {
      switch (*name)
	{
	case '/':
	  *name = '-';
	  break;
	default:
	  break;
	}
      if (*name & 0x80)
	*name = '_';
    }
}

char *
getextension(char *inb)
{
  char *c;
  
  c = NULL;
  if (inb == NULL)
    return(NULL);
  for (; *inb != '\0'; inb++)
    if (*inb == '.')
      c = inb;
  return(c);
}

void fix_filename(struct message *m)
{
  char *extension, *name;
  extension = getextension(m->name);
  if (m->name == NULL)
    m->name = NEWSTR("noname");

  if (m->type != NULL)
    if ((m->nameext = confextr("UUENCODE", NULL, m->type)) == NULL)
      m->nameext = confextr("UUENCODE", NULL, "DEFAULT");

  if (m->nameext == NULL)
    return;
  if (extension == NULL || cmatch(m->nameext, extension) == FALSE)
    {
      name = (char *)Yalloc(strlen(m->name) + strlen(m->nameext) + 2);
      sprintf(name, "%s%s", m->name, m->nameext);
    }
  return;
}
