/*
**
** Copyright (C) 1994 Swedish University Network (SUNET)
**
**
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
**
**                                        Martin.Wendel@udac.uu.se
**                                        Torbjorn.Wictorin@udac.uu.se
**
**                                        UDAC	
**                                        P.O. Box 174
**                                        S-751 04 Uppsala
**                                        Sweden
**
*/


#include "emil.h"

void
check_bits(struct data *d)
{
  int offset;
  char *c;
  if (d->encoding == 0)
    d->encoding = E7BIT;
  if (d->encoding == E7BIT)
    {
      for (offset = d->bodystart, c = d->contents + offset;
	   offset < d->bodyend;
	   offset++, c++)
	{
	  if (*c == '\0')
	    {
	      d->encoding = EBINARY;
	      return;
	    }
	  if (*c & 0x80)
	    {
	      d->encoding = E8BIT;
	    }
	}
      return;
    }
  if (d->encoding == E8BIT)
    {
      for (offset = d->bodystart, c = d->contents + offset;
	   offset < d->bodyend;
	   offset++, c++)
	{
	  if (*c == '\0')
	    {
	      d->encoding = EBINARY;
	      return;
	    }
	}
    }
  return;
}
