/***********************************************************
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*
*  Date:            28 March, 1991
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/
#ifndef _XbBrowser_h 
#define _XbBrowser_h

#include <X11/StringDefs.h>

#include <X11/Xaw/Viewport.h>
#include "List.h"

extern WidgetClass XbbrowserWidgetClass;

typedef struct _XbBrowserClassRec       *XbBrowserWidgetClass;
typedef struct _XbBrowserRec            *XbBrowserWidget;

#define XtNinitialViewHt    "initialViewHt"
#define XtNminimumView      "minimumView"
#define XtNlistPosition     "listPosition"
#define XtNinitialHighlight "initialHighlight"
#define XtNsingleClick      "singleClick"
#define XtNbuttonData       "buttonData"
#define XtNbuttonList       "buttonList"

#define XtCInitialViewHt    "InitialViewHt"
#define XtCMinimumView      "MinimumView"
#define XtCListPosition     "ListPosition"
#define XtCInitialHighlight "InitialHighlight"
#define XtCSingleClick      "SingleClick"
#define XtCButtonList       "ButtonList"
#define XtCButtonData       "ButtonData"

extern int XbBrowserGetPosition( /* Widget  */ );
extern int XbBrowserGetView( /* Widget  */ );
extern XbListEntry* XbBrowserGetItem(/* WIdget, int */);
extern void XbBrowserSetPosition( /* Widget , int  */ );
extern char* XbBrowserReplaceString( /* Widget , XbListEntryPtr  */ );
extern XbListSelectionPtr XbBrowserGetItems( /* Widget  */ );
extern XbListSelectionPtr XbBrowserChangeItems(/* Widget , XbListSeelection* */);
extern XbListSelectionPtr XbBrowserCurrentHighlight( /* Widget */ );
extern void XbBrowserHighlight( /* Widget , ListMapping *, int  */ );
extern void XbBrowserUnHighlight( /* Widget */ );

extern void XbBrowserSortBrowser(/* Widget, int */);

#endif /* _XbBrowser_h */




