/* -*- C -*-
 *
 * Program:	ximap
 * File:        buttons.c -- Makes buttons and menus from ButtonStructs.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#include <stdio.h>
#include <string.h>

#include <Client/osdep.h>
#include <Client/mail.h>
#include <Client/misc.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>

#include <Xb/CascadeMenu.h>
#include <Xb/SmeCasc.h>
#include <Xb/BSBMnBt.h>

#include "structures.h"
#include "globals.h"
#include "buttons.h"

extern XtAppContext app_context;

Arg barg[16];
int bn = 0;

StateList* createButtons(box, data, button_list)
     Widget     box;
     void       *data;
     ButtonStructPtr button_list;
{
    StateList* buttonStates = makeStateList( box, button_list, data, 0 );

    return (buttonStates);
}

StateList* makeStateList(parent, buttons, data, depth)
     Widget parent;
     ButtonStructPtr buttons;
     void *data;
     int  depth;
{
    char menuName[TMPLEN];
    char *cptr;
    Widget menu = NULL;
    StateList* first = NULL;
    StateList* stmp = NULL;
    StateList* oldState = NULL;

    while( buttons->name != NULL )
    {
	stmp = (StateList*)XtMalloc(sizeof(StateList));

	if( first == NULL )
	    first = stmp;

	if(oldState)
	    oldState->next = stmp;

	if( buttons->function )
	{
	    if(depth == 0)
	    {
		stmp->states = buttons->state;
		stmp->button = XtCreateManagedWidget(buttons->name,
						     commandWidgetClass, parent,
						     barg, bn); bn = 0;
		
		XtAddCallback(stmp->button, XtNcallback, buttons->function, data);  
	    }
	    else
	    {
		stmp->states = buttons->state;
		stmp->button = XtCreateManagedWidget(buttons->name,
						     smeBSBObjectClass,
						     parent, barg, bn); bn = 0;
		XtAddCallback(stmp->button, XtNcallback, buttons->function, data);
	    }
	}
	else
	{
	    sprintf( menuName, "%s_menu", buttons->name );
	    cptr = XtMalloc(1 + strlen(menuName));
	    strcpy(cptr,menuName);

	    if( depth == 0 )
	    {
		stmp->states = buttons->state;
		XtSetArg(barg[bn], XtNmenuName, cptr); bn++;
		stmp->button = XtCreateManagedWidget(buttons->name,
						     bsbMnBtWidgetClass, parent,
						     barg, bn); bn = 0;
		
		menu = XtCreatePopupShell(cptr, cascadeMenuWidgetClass,
					  stmp->button, barg, bn); bn = 0;

		stmp->next = makeStateList( menu, buttons->menu, data, depth+1 );
	    }
	    else 
	    {
		menu = XtCreatePopupShell(buttons->name,
					  cascadeMenuWidgetClass,
					  parent, barg, bn); bn = 0;

		stmp->next = makeStateList(menu,buttons->menu,data, depth+1);
		stmp->states = buttons->state;

		XtSetArg(barg[bn], XtNmenu, menu); bn++;
		stmp->button = XtCreateManagedWidget(buttons->name,
						     smeCascObjectClass,
						     parent, barg, bn); bn = 0;		
	    }
	    if(stmp->next == NULL)
		stmp->states = NEVER;

	    while(stmp->next)
		stmp = stmp->next;
	}
	++buttons;
	oldState = stmp;
    }
    if(oldState)
	oldState->next = NULL;

    return( first );
}

void checkButtonStates( sl, current )
     StateList* sl;
     unsigned int current;
{
    Arg barg[1];
    StateList* stmp = sl;
    Boolean sens = FALSE;

    while(stmp)
    {
	if(stmp->states & current)
	    sens = FALSE;
	else 
	    sens = TRUE;

	XtSetArg(barg[0], XtNsensitive, sens);
	XtSetValues( stmp->button, barg, 1 );
	
	stmp = stmp->next;
    }
}

Widget buttonFromStateList( sl, name )
     StateList* sl;
     char *name;
{
    while(sl && strcmp(name, XtName(sl->button)))
	sl = sl->next;
	
    if( sl )
	return (sl->button);
    else
	return( NULL );
}

void free_statelist(s)
     StateList *s;
{
    StateList *tmp = s;
    while (tmp)
    {
	tmp = tmp->next;
	XtFree(s);
	s = tmp;
    }
}

/* Creates a single menu for a menuButton widget (or bsbMnBt widget) */
Widget makeMenu(parentButton, name, data, entries)
     Widget parentButton;
     char  *name;
     void  *data;
     ButtonStruct *entries;
{
    Widget menu = NULL;
    menu = XtCreatePopupShell(name, cascadeMenuWidgetClass,
			      parentButton, barg, bn); bn = 0;
    
    makeStateList(menu, entries, data, 1);
    return(menu);
}
