/* -*- C -*-
 *
 * Program:	ximap
 * File:        message.h -- declarations for fns dealing with
 *                           MessageNodes.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_message_h
#define __ximap_message_h

#if defined(__cplusplus) || defined( __STDC__ )
#define __XB_NEEDPROTOTYPES__
#endif

void free_node( 
#ifdef __XB_NEEDPROTOTYPES__
MessageNode* node
#endif
);

MessageNode* ximap_newnode( 
#ifdef __XB_NEEDPROTOTYPES__
#endif
);

NodeList* ximap_newnodelist( 
#ifdef __XB_NEEDPROTOTYPES__
MessageNode* *nodes,
int          number
#endif
);

void headerline( 
#ifdef __XB_NEEDPROTOTYPES__
char *text,
MAILSTREAM *stream,
MESSAGECACHE *elt
#endif
);

Boolean empty_line( 
#ifdef __XB_NEEDPROTOTYPES__
char *line
#endif
);

char* parse_news_from(
#ifdef __XB_NEEDPROTOTYPES__
MAILSTREAM *stream,
int        msgno,
int        length
#endif
);

char* parse_news_newsgroups(
#ifdef __XB_NEEDPROTOTYPES__
MAILSTREAM *stream,
int        msgno,
int        length
#endif
);

void parse_multimedia();
void parse_message();

#endif /* __ximap_message_h */

