/*
 * Copyright (C) 1996-2001 Michael R. Elkins <me@cs.hmc.edu>
 * Copyright (C) 1999-2001 Thomas Roessler <roessler@guug.de>
 * 
 *     This program is free software; you can redistribute it
 *     and/or modify it under the terms of the GNU General Public
 *     License as published by the Free Software Foundation; either
 *     version 2 of the License, or (at your option) any later
 *     version.
 * 
 *     This program is distributed in the hope that it will be
 *     useful, but WITHOUT ANY WARRANTY; without even the implied
 *     warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *     PURPOSE.  See the GNU General Public License for more
 *     details.
 * 
 *     You should have received a copy of the GNU General Public
 *     License along with this program; if not, write to the Free
 *     Software Foundation, Inc., 59 Temple Place - Suite 330,
 *     Boston, MA  02111, USA.
 */ 

#ifndef _LIB_H
# define _LIB_H

# include "config.h"

# include <stdio.h>
# include <stdlib.h>
# include <ctype.h>
# include <string.h>
# ifdef HAVE_UNISTD_H
#  include <unistd.h> /* needed for SEEK_SET */
# endif
# include <sys/types.h>
# include <sys/stat.h>
# include <time.h>
# include <limits.h>
# include <stdarg.h>
# include <signal.h>

# ifndef _POSIX_PATH_MAX
#  include <posix1_lim.h>
# endif

# define TRUE 1
# define FALSE 0

# define HUGE_STRING	 5120
# define LONG_STRING     1024
# define STRING          256
# define SHORT_STRING    128
# define BUFFLEN	 0xffff 

# define FREE(x) safe_free((void **)x)
# define NONULL(x) x?x:""
# define ISSPACE(c) isspace((unsigned char)c)
# define strfcpy(A,B,C) strncpy(A,B,C), *(A+(C)-1)=0

/* this macro must check for *c == 0 since isspace(0) has unreliable behavior
   on some systems */
# define SKIPWS(c) while (*(c) && isspace ((unsigned char) *(c))) c++;

/* The actual library functions. */

FILE *safe_fopen (const char *, const char *);

char *safe_strdup (const char *);

int safe_open (const char *, int);
int safe_symlink (const char *, const char *);
int safe_rename (const char *, const char *);
int safe_fclose (FILE **);

void *safe_calloc (size_t, size_t);
void *safe_malloc (size_t);

void safe_free (void **);
void safe_realloc (void **, size_t);

void pm_exit (int retcode);
void pm_msg (const char *fmt, ...);
void pm_perror (const char *);

void str_replace (char **, const char *);


#endif
