.\" -*-nroff-*-
.\"
.\"
.\"     Copyright (C) 1996-2000 Michael R. Elkins <me@cs.hmc.edu>
.\" 
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\" 
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\" 
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
.\"
.TH mutt 1 "January 2002" Unix "User Manuals"
.SH NAME
.PP
mutt \- The Mutt Mail User Agent
.SH SYNOPSIS
.PP
.B mutt
[-nRyzZ] 
[-e \fIcmd\fP] [-F \fIfile\fP] [-m \fItype\fP] [-f \fIfile\fP]
.PP
.B mutt 
[-nx] 
[-e \fIcmd\fP] 
[-a \fIfile\fP]
[-F \fIfile\fP]
[-H \fIfile\fP]
[-i \fIfile\fP]
[-s \fIsubj\fP]
[-b \fIaddr\fP]
[-c \fIaddr\fP] \fIaddr\fP [...]
.PP
.B mutt
[-n] [-e \fIcmd\fP] [-F \fIfile\fP] -p
.PP
.B mutt
[-n] [-e \fIcmd\fP] [-F \fIfile\fP] -Q \fIquery\fP
.PP
.B mutt
[-n] [-e \fIcmd\fP] [-F \fIfile\fP] -A \fIalias\fP
.PP
.B mutt 
-v[v]
.SH DESCRIPTION
.PP
Mutt is a small but very powerful text based program for reading electronic
mail under unix operating systems, including support color terminals, MIME,
and a threaded sorting mode.
.SH OPTIONS
.PP
.IP "-A \fIalias\fP"
An expanded version of the given alias is passed to stdout.
.IP "-a \fIfile\fP"
Attach a file to your message using MIME.
.IP "-b \fIaddress\fP"
Specify a blind-carbon-copy (BCC) recipient
.IP "-c \fIaddress\fP"
Specify a carbon-copy (CC) recipient
.IP "-e \fIcommand\fP"
Specify a configuration command to be run after processing of initialization
files.
.IP "-f \fImailbox\fP"
Specify which mailbox to load.
.IP "-F \fImuttrc\fP"
Specify an initialization file to read instead of ~/.muttrc
.IP "-h"
Display help.
.IP "-H \fIdraft\fP"
Specify a draft file which contains header and body to use to send a
message.
.IP "-i \fIinclude\fP"
Specify a file to include into the body of a message.
.IP "-m \fItype\fP       "
specify a default mailbox type
.IP "-n"
Causes Mutt to bypass the system configuration file.
.IP "-p"
Resume a postponed message.
.IP "-Q \fIquery\fP"
Qeury a configuration variables value.  The query is executed after
all configuration files have been parsed, and any commands given on
the command line have been executed.
.IP "-R"
Open a mailbox in \fIread-only\fP mode.
.IP "-s \fIsubject\fP"
Specify the subject of the message.
.IP "-v"
Display the Mutt version number and compile-time definitions.
.IP "-x"
Emulate the mailx compose mode.
.IP "-y"
Start Mutt with a listing of all mailboxes specified by the \fImailboxes\fP
command.
.IP "-z"
When used with -f, causes Mutt not to start if there are no messages in the
mailbox.
.IP "-Z"
Causes Mutt to open the first mailbox specified by the \fImailboxes\fP
command which contains new mail.
.SH ENVIRONMENT
.PP
.IP "EDITOR"
Specifies the editor to use if VISUAL is unset.
.IP "EMAIL"
The user's e-mail address.
.IP "HOME"
Full path of the user's home directory.
.IP "MAIL"
Full path of the user's spool mailbox.
.IP "MAILDIR"
Full path of the user's spool mailbox.  Commonly used when the spool
mailbox is a 
.B maildir (5)
folder.
.IP "MAILCAPS"
Path to search for mailcap files.
.IP "MM_NOASK"
If this variable is set, mailcap are always used without prompting first.
.IP "PGPPATH"
Directory in which the user's PGP public keyring can be found.
.IP "TMPDIR"
Directory in which temporary files are created.
.IP "REPLYTO"
Default Reply-To address.
.IP "VISUAL"
Specifies the editor to use when composing messages.
.SH FILES
.PP
.IP "~/.muttrc or ~/.mutt/muttrc"
User configuration file.
.IP "/etc/Muttrc"
System-wide configuration file.
.IP "/tmp/muttXXXXXX"
Temporary files created by Mutt.
.IP "~/.mailcap"
User definition for handling non-text MIME types.
.IP "/etc/mailcap"
System definition for handling non-text MIME types.
.IP "~/.mime.types"
User's personal mapping between MIME types and file extensions.
.IP "/etc/mime.types"
System mapping between MIME types and file extensions.
.IP "/usr/local/bin/mutt_dotlock"
The privileged dotlocking program.
.IP "/usr/local/doc/mutt/manual.txt"
The Mutt manual.
.SH BUGS
.PP
None.  Mutts have fleas, not bugs.
.SH FLEAS
.PP
Suspend/resume while editing a file with an external editor does not work
under SunOS 4.x if you use the curses lib in /usr/5lib.  It \fIdoes\fP work
with the S-Lang library, however.
.PP
Resizing the screen while using an external pager causes Mutt to go haywire
on some systems.
.PP
suspend/resume does not work under Ultrix.
.PP
The help line for the index menu is not updated if you change the bindings
for one of the functions listed while Mutt is running.
.PP
For a more up-to-date list of bugs, errm, fleas, please visit the
mutt project's bug tracking system under http://bugs.guug.de/.  To
report a bug, please use the
.BR flea (1)
program.
.SH NO WARRANTIES
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.SH SEE ALSO
.PP
.BR curses (3),
.BR flea (1),
.BR mailcap (5),
.BR maildir (5),
.BR mbox (5),
.BR mutt_dotlock (1),
.BR muttrc (5),
.BR ncurses (3),
.BR sendmail (1),
.BR smail (1)
.PP
Mutt Home Page: http://www.mutt.org/
.PP
The Mutt manual
.PP
The GNU General Public License.
.SH AUTHOR
.PP
Michael Elkins, and others.  Use <mutt-dev@mutt.org> to contact
the developers.
