.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH SHOW %manext1% MH.6.8 [%nmhversion%]
.SH NAME
show \- show (display) messages
.SH SYNOPSIS
.in +.5i
.ti -.5i
show
\%[+folder] \%[msgs]
\%[\-showproc\ program]
.br
\%[\-mhnproc\ program]
\%[\-header] \%[\-noheader]
.br
\%[\-draft]
\%[\-checkmime] \%[\-nocheckmime]
.br
\%[switches\ for\ \fIshowproc\fR or \fImhnproc\fR]
.br
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIShow\fR lists each of the specified messages to the standard output
(typically, the terminal).

By default, non-MIME messages are listed with no reformatting, by
the \fImore\fR(1) command.  This default can be changed by defining
the \fIshowproc\fR profile component.  Any switches not recognized by
\fIshow\fR are passed along to that program.  To override the default
and the \fIshowproc\fR profile component, use the `\-showproc\ program'
switch.  For example, `\-showproc\ less' will cause the \fIless\fR(1)
program to list the messages.  The \fInmh\fR command \fImhl\fR can be used
as a \fIshowproc\fR to show non-MIME messages in a more uniform format.
Normally, this program is specified as the \fIshowproc\fR in the user's
\&.mh\(ruprofile.  See the \fImhl\fR(1) manual page for details about
this command.

By default, MIME messages (messages with multi-media contents) are
processed and displayed by the \fInmh\fR command \fImhn\fR(1).  See the
\fImhn\fR(1) manual page for details about this command.  This default
can changed by defining the \fImhnproc\fR profile component.  Any switches
not recognized by \fIshow\fR are passed along to that program.  To override
the default and the \fImhnproc\fR profile component, use the
`\-mhnproc\ program' switch.

Note that the \fImhnproc\fR may be invoked even for textual contents,
depending on the character set involved.  The environment variable
MM_CHARSET should be set to the terminal's character set to avoid
gratuitous invocations of the \fImhnproc\fR.

The option `\-checkmime' (set by default) instructs \fIshow\fR to test
if any of the messages to be displayed are MIME messages.  If any are
MIME, they are displayed by the program \fImhnproc\fR, else they are
displayed by the program \fIshowproc\fR.  The option `-nocheckmime'
disables this test and instructs \fIshow\fR to use \fIshowproc\fR,
regardless of whether any of the messages are MIME messages.

The `\-noshowproc' switch will disable any formatting or paging of
messages.  It is equivalent to `-nocheckmime\ -showproc\ cat'.  It is
still accepted, but should be considered obsolete.

If the environment variable \fBNOMHNPROC\fR is set, the test for
MIME messages will be disabled.  This method is obsolete.  Use the
`-nocheckmime' switch instead.

The `\-header' switch tells \fIshow\fR to display a one\-line description
of the message being shown.  This description includes the folder and
the message number.

If no `msgs' are specified, the current message is used.  Although it
depends on the specific \fIshowproc\fR or \fImhnproc\fR, in the default
setup when more than one message is specified, you will be prompted for
a <RETURN> prior to listing each message.  Each message will be listed
a page at a time, and when the end of page is reached, the program will
wait for a <SPACE> or <RETURN>.  If a <RETURN> is entered, it will print
the next line, whereas <SPACE> will print the next screenful.

If the standard output is not a terminal, no queries are made, and each
file is listed with a one\-line header and two lines of separation.

\*(lqshow \-draft\*(rq will list the file <mh\-dir>/draft if it exists.

If the profile entry \*(lqUnseen\-Sequence\*(rq is present and
non\-empty, then \fIshow\fR will remove each of the messages shown
from each sequence named by the profile entry.  This is similar to the
\*(lqPrevious\-Sequence\*(rq profile entry supported by all \fInmh\fR
commands which take `msgs' or `msg' arguments.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^Unseen\-Sequence:~^To name sequences denoting unseen messages
.Ps
^showproc:~^Program to show non-MIME messages
.Ps
^mhnproc:~^Program to show MIME messages
.Sa
mhl(1), mhn(1), more(1), next(1), prev(1), scan(1)
.De
`+folder' defaults to the current folder
.Ds
`msgs' defaults to cur
.Ds
`\-checkmime'
.Ds
`\-header'
.Co
If a folder is given, it will become the current folder.  The last
message shown will become the current message.
.Bu
The `\-header' switch doesn't work when `msgs' expands to more than
one message.  If the \fIshowproc\fR is \fImhl\fR, then is problem can
be circumvented by referencing the \*(lqmessagename\*(rq field in the
\fImhl\fR format file.

\fIShow\fR updates the user's context before showing the message.
Hence \fIshow\fR will mark messages as seen prior to the user actually
seeing them.  This is generally not a problem, unless the user relies
on the \*(lqunseen\*(rq messages mechanism, and interrupts \fIshow\fR
while it is showing \*(lqunseen\*(rq messages.

If \fIshowproc\fR is \fImhl\fR, then \fIshow\fR uses a built\-in
\fImhl\fR: it does not actually run the \fImhl\fR program.  Hence, if you
define your own \fIshowproc\fR, don't call it \fImhl\fR since \fIshow\fR
won't run it.

If \fImore\fR\0(1) is your showproc (the default), then avoid running
\fIshow\fR in the background with only its standard output piped to
another process, as in

.ti +.5i
show | imprint &

Due to a bug in \fImore\fR, show will go into a \*(lqtty input\*(rq state.
To avoid this problem, re\-direct \fIshow\fR's diagnostic output as well.
For users of \fIcsh\fR:

.ti +.5i
show |& imprint &

For users of \fIsh\fR:

.ti +.5i
show 2>&1 | imprint &
.En
